/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:outline-style}.
 *
 */
public abstract class OdfOutlineStyleElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "outline-style" );

    /**
     * Create the instance of OdfOutlineStyleElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfOutlineStyleElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:outline-style}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfOutlineStyleElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *
     */
    public void init(OdfStyleName name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name.toString() );
    }

    /**
    * Create child element {@odfLink text:outline-level-style}.
    *
    *@param level  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param numFormat String   
    *@return   return  the element {@odfLink text:outline-level-style}
    */
    public OdfOutlineLevelStyleElement createOutlineLevelStyleElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   level, String   numFormat)
    {
        OdfOutlineLevelStyleElement  nOutlineLevelStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOutlineLevelStyleElement.class);
        nOutlineLevelStyle.setLevel( level);
        nOutlineLevelStyle.setNumFormat( numFormat);
        this.appendChild( nOutlineLevelStyle);
        return  nOutlineLevelStyle;      
    }
    
    /**
    * Create child element {@odfLink text:outline-level-style}.
    *
    *@param numFormat   the attribute's type is String
    *@param level  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:outline-level-style}
    */
    public OdfOutlineLevelStyleElement createOutlineLevelStyleElement(String   numFormat, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   level)
    {
        OdfOutlineLevelStyleElement  nOutlineLevelStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOutlineLevelStyleElement.class);
        nOutlineLevelStyle.setNumFormat( numFormat);
        nOutlineLevelStyle.setLevel( level);
        this.appendChild( nOutlineLevelStyle);
        return  nOutlineLevelStyle;      
    }
    
}
