/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfIndexScopeType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:object-index-source}.
 *
 */
public abstract class OdfObjectIndexSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "object-index-source" );

    /**
     * Create the instance of OdfObjectIndexSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfObjectIndexSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:object-index-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:index-scope}.
     *
     *@return return the attribute which type is OdfIndexScopeType
     */
    public OdfIndexScopeType getIndexScope()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "document";
        }

        return OdfIndexScopeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:index-scope}.
     *
     *@param  indexScope    the attribute's type is OdfIndexScopeType
     */ 
     public void setIndexScope( OdfIndexScopeType indexScope )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ), indexScope.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRelativeTabStopPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@param  isRelativeTabStopPosition    the attribute's type is OdfBoolean
     */ 
     public void setRelativeTabStopPosition( OdfBoolean isRelativeTabStopPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ), isRelativeTabStopPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-spreadsheet-objects}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseSpreadsheetObjects()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-spreadsheet-objects" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-spreadsheet-objects}.
     *
     *@param  isUseSpreadsheetObjects    the attribute's type is OdfBoolean
     */ 
     public void setUseSpreadsheetObjects( OdfBoolean isUseSpreadsheetObjects )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-spreadsheet-objects" ), isUseSpreadsheetObjects.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-math-objects}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseMathObjects()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-math-objects" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-math-objects}.
     *
     *@param  isUseMathObjects    the attribute's type is OdfBoolean
     */ 
     public void setUseMathObjects( OdfBoolean isUseMathObjects )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-math-objects" ), isUseMathObjects.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-draw-objects}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseDrawObjects()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-draw-objects" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-draw-objects}.
     *
     *@param  isUseDrawObjects    the attribute's type is OdfBoolean
     */ 
     public void setUseDrawObjects( OdfBoolean isUseDrawObjects )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-draw-objects" ), isUseDrawObjects.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-chart-objects}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseChartObjects()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-chart-objects" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-chart-objects}.
     *
     *@param  isUseChartObjects    the attribute's type is OdfBoolean
     */ 
     public void setUseChartObjects( OdfBoolean isUseChartObjects )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-chart-objects" ), isUseChartObjects.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-other-objects}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseOtherObjects()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-other-objects" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-other-objects}.
     *
     *@param  isUseOtherObjects    the attribute's type is OdfBoolean
     */ 
     public void setUseOtherObjects( OdfBoolean isUseOtherObjects )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-other-objects" ), isUseOtherObjects.toString() );
    }

    /**
    * Create child element {@odfLink text:index-title-template}.
    *
    *@return   return  the element {@odfLink text:index-title-template}
    */
    public OdfIndexTitleTemplateElement createIndexTitleTemplateElement()
    {
        OdfIndexTitleTemplateElement  nIndexTitleTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexTitleTemplateElement.class);
        this.appendChild( nIndexTitleTemplate);
        return  nIndexTitleTemplate;
    }                   
               
    /**
    * Create child element {@odfLink text:object-index-entry-template}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink text:object-index-entry-template}
    */
    public OdfObjectIndexEntryTemplateElement createObjectIndexEntryTemplateElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfObjectIndexEntryTemplateElement  nObjectIndexEntryTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfObjectIndexEntryTemplateElement.class);
        nObjectIndexEntryTemplate.setStyleName( styleName);
        this.appendChild( nObjectIndexEntryTemplate);
        return  nObjectIndexEntryTemplate;      
    }
    
}
