/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfId;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:numbered-paragraph}.
 *
 */
public abstract class OdfNumberedParagraphElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "numbered-paragraph" );

    /**
     * Create the instance of OdfNumberedParagraphElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfNumberedParagraphElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.List, OdfName.get( OdfNamespace.TEXT, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:numbered-paragraph}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfNumberedParagraphElement}
     *
     *@param listId  The mandatory attribute {@attributeName  text:list-id}" 
     *
     */
    public void init(String listId)
    {
        setListId( listId );
    }

    /**
     * Get value of attribute {@attributeName text:list-id}.
     *
     *@return return the attribute which type is String
     */
    public String getListId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "list-id" ) );
    }

    /**
     * Set value of attribute {@attributeName text:list-id}.
     *
     *@param  listId    the attribute's type is String
     */ 
     public void setListId( String listId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "list-id" ), listId );
    }

    /**
     * Get value of attribute {@attributeName text:level}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "level" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1";
        }

        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:level}.
     *
     *@param  level    the attribute's type is OdfPositiveInteger
     */ 
     public void setLevel( OdfPositiveInteger level )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "level" ), level.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:continue-numbering}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getContinueNumbering()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "continue-numbering" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:continue-numbering}.
     *
     *@param  isContinueNumbering    the attribute's type is OdfBoolean
     */ 
     public void setContinueNumbering( OdfBoolean isContinueNumbering )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "continue-numbering" ), isContinueNumbering.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:start-value}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getStartValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "start-value" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:start-value}.
     *
     *@param  startValue    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setStartValue( OdfNonNegativeInteger startValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "start-value" ), startValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink text:number}.
    *
    *@return   return  the element {@odfLink text:number}
    */
    public OdfNumberElement createNumberElement()
    {
        OdfNumberElement  nNumber = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNumberElement.class);
        this.appendChild( nNumber);
        return  nNumber;
    }                   
               
    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
    /**
    * Create child element {@odfLink text:h}.
    *
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:h}
    */
    public OdfHeadingElement createHeadingElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   outlineLevel)
    {
        OdfHeadingElement  nHeading = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHeadingElement.class);
        nHeading.setOutlineLevel( outlineLevel);
        this.appendChild( nHeading);
        return  nHeading;      
    }
    
}
