/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfNoteClassType;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.text.OdfStartNumberingAtType;
import org.odftoolkit.odfdom.dom.type.text.OdfFootnotesPositionType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:notes-configuration}.
 *
 */
public abstract class OdfNotesConfigurationElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "notes-configuration" );

    /**
     * Create the instance of OdfNotesConfigurationElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfNotesConfigurationElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:notes-configuration}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfNotesConfigurationElement}
     *
     *@param noteClass  The mandatory attribute {@attributeName  text:note-class}" 
     *
     */
    public void init(OdfNoteClassType noteClass)
    {
        setNoteClass( noteClass );
    }

    /**
     * Get value of attribute {@attributeName text:note-class}.
     *
     *@return return the attribute which type is OdfNoteClassType
     */
    public OdfNoteClassType getNoteClass()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "note-class" ) );
        return OdfNoteClassType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:note-class}.
     *
     *@param  noteClass    the attribute's type is OdfNoteClassType
     */ 
     public void setNoteClass( OdfNoteClassType noteClass )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "note-class" ), noteClass.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:citation-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getCitationStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "citation-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:citation-style-name}.
     *
     *@param  citationStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setCitationStyleName( OdfStyleNameRef citationStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "citation-style-name" ), citationStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:citation-body-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getCitationBodyStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "citation-body-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:citation-body-style-name}.
     *
     *@param  citationBodyStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setCitationBodyStyleName( OdfStyleNameRef citationBodyStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "citation-body-style-name" ), citationBodyStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:default-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDefaultStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "default-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:default-style-name}.
     *
     *@param  defaultStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDefaultStyleName( OdfStyleNameRef defaultStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "default-style-name" ), defaultStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:master-page-name}.
     *
     *@return return the attribute which type is String
     */
    public String getMasterPageName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "master-page-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:master-page-name}.
     *
     *@param  masterPageName    the attribute's type is OdfStyleNameRef
     */ 
     public void setMasterPageName( OdfStyleNameRef masterPageName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "master-page-name" ), masterPageName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:start-value}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getStartValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "start-value" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1";
        }

        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:start-value}.
     *
     *@param  startValue    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setStartValue( OdfNonNegativeInteger startValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "start-value" ), startValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:num-prefix}.
     *
     *@return return the attribute which type is String
     */
    public String getNumPrefix()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-prefix" ) );
    }

    /**
     * Set value of attribute {@attributeName style:num-prefix}.
     *
     *@param  numPrefix    the attribute's type is String
     */ 
     public void setNumPrefix( String numPrefix )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-prefix" ), numPrefix );
    }

    /**
     * Get value of attribute {@attributeName style:num-suffix}.
     *
     *@return return the attribute which type is String
     */
    public String getNumSuffix()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-suffix" ) );
    }

    /**
     * Set value of attribute {@attributeName style:num-suffix}.
     *
     *@param  numSuffix    the attribute's type is String
     */ 
     public void setNumSuffix( String numSuffix )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-suffix" ), numSuffix );
    }

    /**
     * Get value of attribute {@attributeName style:num-format}.
     *
     *@return return the attribute which type is String
     */
    public String getNumFormat()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-format" ) );
    }

    /**
     * Set value of attribute {@attributeName style:num-format}.
     *
     *@param  numFormat    the attribute's type is String
     */ 
     public void setNumFormat( String numFormat )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-format" ), numFormat );
    }

    /**
     * Get value of attribute {@attributeName style:num-letter-sync}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getNumLetterSync()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-letter-sync" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:num-letter-sync}.
     *
     *@param  isNumLetterSync    the attribute's type is OdfBoolean
     */ 
     public void setNumLetterSync( OdfBoolean isNumLetterSync )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-letter-sync" ), isNumLetterSync.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:start-numbering-at}.
     *
     *@return return the attribute which type is OdfStartNumberingAtType
     */
    public OdfStartNumberingAtType getStartNumberingAt()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "start-numbering-at" ) );
        return OdfStartNumberingAtType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:start-numbering-at}.
     *
     *@param  startNumberingAt    the attribute's type is OdfStartNumberingAtType
     */ 
     public void setStartNumberingAt( OdfStartNumberingAtType startNumberingAt )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "start-numbering-at" ), startNumberingAt.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:footnotes-position}.
     *
     *@return return the attribute which type is OdfFootnotesPositionType
     */
    public OdfFootnotesPositionType getFootnotesPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "footnotes-position" ) );
        return OdfFootnotesPositionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:footnotes-position}.
     *
     *@param  footnotesPosition    the attribute's type is OdfFootnotesPositionType
     */ 
     public void setFootnotesPosition( OdfFootnotesPositionType footnotesPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "footnotes-position" ), footnotesPosition.toString() );
    }

}
