/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfReferenceFormatType;
import org.odftoolkit.odfdom.dom.type.text.OdfNoteClassType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:note-ref}.
 *
 */
public abstract class OdfNoteRefElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "note-ref" );

    /**
     * Create the instance of OdfNoteRefElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfNoteRefElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:note-ref}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfNoteRefElement}
     *
     *@param noteClass  The mandatory attribute {@attributeName  text:note-class}" 
     *
     */
    public void init(OdfNoteClassType noteClass)
    {
        setNoteClass( noteClass );
    }

    /**
     * Get value of attribute {@attributeName text:ref-name}.
     *
     *@return return the attribute which type is String
     */
    public String getRefName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "ref-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:ref-name}.
     *
     *@param  refName    the attribute's type is String
     */ 
     public void setRefName( String refName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "ref-name" ), refName );
    }

    /**
     * Get value of attribute {@attributeName text:reference-format}.
     *
     *@return return the attribute which type is OdfReferenceFormatType
     */
    public OdfReferenceFormatType getReferenceFormat()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "reference-format" ) );
        return OdfReferenceFormatType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:reference-format}.
     *
     *@param  referenceFormat    the attribute's type is OdfReferenceFormatType
     */ 
     public void setReferenceFormat( OdfReferenceFormatType referenceFormat )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "reference-format" ), referenceFormat.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:note-class}.
     *
     *@return return the attribute which type is OdfNoteClassType
     */
    public OdfNoteClassType getNoteClass()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "note-class" ) );
        return OdfNoteClassType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:note-class}.
     *
     *@param  noteClass    the attribute's type is OdfNoteClassType
     */ 
     public void setNoteClass( OdfNoteClassType noteClass )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "note-class" ), noteClass.toString() );
    }

}
