/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfId;

import java.net.URI;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.text.OdfNoteClassType;
import org.odftoolkit.odfdom.dom.element.office.OdfAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OdfAnnotationEndElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfRectElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfLineElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPolylineElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfRegularPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPathElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCircleElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfEllipseElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfGroupElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCaptionElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfControlElement;
import org.odftoolkit.odfdom.dom.element.dr3d.OdfSceneElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCustomShapeElement;
import org.odftoolkit.odfdom.dom.type.text.OdfPageContiuationSelectType;
import org.odftoolkit.odfdom.dom.type.text.OdfChapterDisplayType;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.text.OdfPlaceholderType;
import org.odftoolkit.odfdom.dom.type.text.OdfKindType;
import org.odftoolkit.odfdom.dom.type.text.OdfBibliographyType;
import org.odftoolkit.odfdom.dom.element.presentation.OdfHeaderElement;
import org.odftoolkit.odfdom.dom.element.presentation.OdfFooterElement;
import org.odftoolkit.odfdom.dom.element.presentation.OdfDateTimeElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:meta}.
 *
 */
public abstract class OdfMetaElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "meta" );

    /**
     * Create the instance of OdfMetaElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfMetaElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:meta}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName xhtml:about}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getAbout()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "about" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xhtml:about}.
     *
     *@param  about    the attribute's type is OdfAnyURI
     */ 
     public void setAbout( OdfAnyURI about )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "about" ), about.toString() );
    }

    /**
     * Get value of attribute {@attributeName xhtml:property}.
     *
     *@return return the attribute which type is String
     */
    public String getProperty()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "property" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:property}.
     *
     *@param  property    the attribute's type is String
     */ 
     public void setProperty( String property )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "property" ), property );
    }

    /**
     * Get value of attribute {@attributeName xhtml:datatype}.
     *
     *@return return the attribute which type is String
     */
    public String getDatatype()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "datatype" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:datatype}.
     *
     *@param  datatype    the attribute's type is String
     */ 
     public void setDatatype( String datatype )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "datatype" ), datatype );
    }

    /**
     * Get value of attribute {@attributeName xhtml:content}.
     *
     *@return return the attribute which type is String
     */
    public String getContent()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "content" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:content}.
     *
     *@param  content    the attribute's type is String
     */ 
     public void setContent( String content )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "content" ), content );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink text:s}.
    *
    *@return   return  the element {@odfLink text:s}
    */
    public OdfSpaceElement createSpaceElement()
    {
        OdfSpaceElement  nSpace = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSpaceElement.class);
        this.appendChild( nSpace);
        return  nSpace;
    }                   
               
    /**
    * Create child element {@odfLink text:tab}.
    *
    *@return   return  the element {@odfLink text:tab}
    */
    public OdfTabElement createTabElement()
    {
        OdfTabElement  nTab = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTabElement.class);
        this.appendChild( nTab);
        return  nTab;
    }                   
               
    /**
    * Create child element {@odfLink text:line-break}.
    *
    *@return   return  the element {@odfLink text:line-break}
    */
    public OdfLineBreakElement createLineBreakElement()
    {
        OdfLineBreakElement  nLineBreak = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLineBreakElement.class);
        this.appendChild( nLineBreak);
        return  nLineBreak;
    }                   
               
    /**
    * Create child element {@odfLink text:soft-page-break}.
    *
    *@return   return  the element {@odfLink text:soft-page-break}
    */
    public OdfSoftPageBreakElement createSoftPageBreakElement()
    {
        OdfSoftPageBreakElement  nSoftPageBreak = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoftPageBreakElement.class);
        this.appendChild( nSoftPageBreak);
        return  nSoftPageBreak;
    }                   
               
    /**
    * Create child element {@odfLink text:span}.
    *
    *@return   return  the element {@odfLink text:span}
    */
    public OdfSpanElement createSpanElement()
    {
        OdfSpanElement  nSpan = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSpanElement.class);
        this.appendChild( nSpan);
        return  nSpan;
    }                   
               
    /**
    * Create child element {@odfLink text:a}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink text:a}
    */
    public org.odftoolkit.odfdom.dom.element.text.OdfHyperlinkElement createtextHyperlinkElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        org.odftoolkit.odfdom.dom.element.text.OdfHyperlinkElement  nHyperlink = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.text.OdfHyperlinkElement.class);
        nHyperlink.setHref( href);
        this.appendChild( nHyperlink);
        return  nHyperlink;      
    }
    
    /**
    * Create child element {@odfLink text:meta}.
    *
    *@return   return  the element {@odfLink text:meta}
    */
    public OdfMetaElement createMetaElement()
    {
        OdfMetaElement  nMeta = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMetaElement.class);
        this.appendChild( nMeta);
        return  nMeta;
    }                   
               
    /**
    * Create child element {@odfLink text:bookmark}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:bookmark}
    */
    public OdfBookmarkElement createBookmarkElement(String   name)
    {
        OdfBookmarkElement  nBookmark = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBookmarkElement.class);
        nBookmark.setName( name);
        this.appendChild( nBookmark);
        return  nBookmark;      
    }
    
    /**
    * Create child element {@odfLink text:bookmark-start}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:bookmark-start}
    */
    public OdfBookmarkStartElement createBookmarkStartElement(String   name)
    {
        OdfBookmarkStartElement  nBookmarkStart = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBookmarkStartElement.class);
        nBookmarkStart.setName( name);
        this.appendChild( nBookmarkStart);
        return  nBookmarkStart;      
    }
    
    /**
    * Create child element {@odfLink text:bookmark-end}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:bookmark-end}
    */
    public OdfBookmarkEndElement createBookmarkEndElement(String   name)
    {
        OdfBookmarkEndElement  nBookmarkEnd = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBookmarkEndElement.class);
        nBookmarkEnd.setName( name);
        this.appendChild( nBookmarkEnd);
        return  nBookmarkEnd;      
    }
    
    /**
    * Create child element {@odfLink text:reference-mark}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:reference-mark}
    */
    public OdfReferenceMarkElement createReferenceMarkElement(String   name)
    {
        OdfReferenceMarkElement  nReferenceMark = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfReferenceMarkElement.class);
        nReferenceMark.setName( name);
        this.appendChild( nReferenceMark);
        return  nReferenceMark;      
    }
    
    /**
    * Create child element {@odfLink text:note}.
    *
    *@param noteClass     the attribute's type is OdfNoteClassType, see {@attributeName  text:note-class} at specification
    *@return   return  the element {@odfLink text:note}
    */
    public OdfNoteElement createNoteElement(OdfNoteClassType   noteClass)
    {
        OdfNoteElement  nNote = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNoteElement.class);
        nNote.setNoteClass( noteClass);
        this.appendChild( nNote);
        return  nNote;      
    }
    
    /**
    * Create child element {@odfLink text:ruby}.
    *
    *@return   return  the element {@odfLink text:ruby}
    */
    public OdfRubyElement createRubyElement()
    {
        OdfRubyElement  nRuby = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRubyElement.class);
        this.appendChild( nRuby);
        return  nRuby;
    }                   
               
    /**
    * Create child element {@odfLink office:annotation}.
    *
    *@return   return  the element {@odfLink office:annotation}
    */
    public OdfAnnotationElement createAnnotationElement()
    {
        OdfAnnotationElement  nAnnotation = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnnotationElement.class);
        this.appendChild( nAnnotation);
        return  nAnnotation;
    }                   
               
    /**
    * Create child element {@odfLink office:annotation-end}.
    *
    *@param name String   
    *@return   return  the element {@odfLink office:annotation-end}
    */
    public OdfAnnotationEndElement createAnnotationEndElement(String   name)
    {
        OdfAnnotationEndElement  nAnnotationEnd = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnnotationEndElement.class);
        nAnnotationEnd.setName( name);
        this.appendChild( nAnnotationEnd);
        return  nAnnotationEnd;      
    }
    
    /**
    * Create child element {@odfLink draw:rect}.
    *
    *@return   return  the element {@odfLink draw:rect}
    */
    public OdfRectElement createRectElement()
    {
        OdfRectElement  nRect = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRectElement.class);
        this.appendChild( nRect);
        return  nRect;
    }                   
               
    /**
    * Create child element {@odfLink draw:line}.
    *
    *@param x1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param x2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink draw:line}
    */
    public OdfLineElement createLineElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        OdfLineElement  nLine = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLineElement.class);
        nLine.setX1( x1);
        nLine.setY1( y1);
        nLine.setX2( x2);
        nLine.setY2( y2);
        this.appendChild( nLine);
        return  nLine;      
    }
    
    /**
    * Create child element {@odfLink draw:polyline}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polyline}
    */
    public OdfPolylineElement createPolylineElement(String   points, Integer   viewBox)
    {
        OdfPolylineElement  nPolyline = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolylineElement.class);
        nPolyline.setPoints( points);
        nPolyline.setViewBox( viewBox);
        this.appendChild( nPolyline);
        return  nPolyline;      
    }
    
    /**
    * Create child element {@odfLink draw:polygon}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polygon}
    */
    public OdfPolygonElement createPolygonElement(String   points, Integer   viewBox)
    {
        OdfPolygonElement  nPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolygonElement.class);
        nPolygon.setPoints( points);
        nPolygon.setViewBox( viewBox);
        this.appendChild( nPolygon);
        return  nPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param concave   the attribute's type is Boolean
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners, org.odftoolkit.odfdom.dom.type.OdfBoolean   concave)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setCorners( corners);
        nRegularPolygon.setConcave( concave);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param concave   the attribute's type is Boolean
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfBoolean   concave, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setConcave( concave);
        nRegularPolygon.setCorners( corners);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:path}.
    *
    *@param d String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:path}
    */
    public OdfPathElement createPathElement(String   d, Integer   viewBox)
    {
        OdfPathElement  nPath = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPathElement.class);
        nPath.setD( d);
        nPath.setViewBox( viewBox);
        this.appendChild( nPath);
        return  nPath;      
    }
    
    /**
    * Create child element {@odfLink draw:circle}.
    *
    *@return   return  the element {@odfLink draw:circle}
    */
    public OdfCircleElement createCircleElement()
    {
        OdfCircleElement  nCircle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCircleElement.class);
        this.appendChild( nCircle);
        return  nCircle;
    }                   
               
    /**
    * Create child element {@odfLink draw:ellipse}.
    *
    *@return   return  the element {@odfLink draw:ellipse}
    */
    public OdfEllipseElement createEllipseElement()
    {
        OdfEllipseElement  nEllipse = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEllipseElement.class);
        this.appendChild( nEllipse);
        return  nEllipse;
    }                   
               
    /**
    * Create child element {@odfLink draw:g}.
    *
    *@return   return  the element {@odfLink draw:g}
    */
    public OdfGroupElement createGroupElement()
    {
        OdfGroupElement  nGroup = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGroupElement.class);
        this.appendChild( nGroup);
        return  nGroup;
    }                   
               
    /**
    * Create child element {@odfLink draw:page-thumbnail}.
    *
    *@return   return  the element {@odfLink draw:page-thumbnail}
    */
    public OdfPageThumbnailElement createPageThumbnailElement()
    {
        OdfPageThumbnailElement  nPageThumbnail = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageThumbnailElement.class);
        this.appendChild( nPageThumbnail);
        return  nPageThumbnail;
    }                   
               
    /**
    * Create child element {@odfLink draw:frame}.
    *
    *@return   return  the element {@odfLink draw:frame}
    */
    public OdfFrameElement createFrameElement()
    {
        OdfFrameElement  nFrame = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFrameElement.class);
        this.appendChild( nFrame);
        return  nFrame;
    }                   
               
    /**
    * Create child element {@odfLink draw:measure}.
    *
    *@param x1  the attribute's type is String
    *@param y1  the attribute's type is String
    *@param x2  the attribute's type is String
    *@param y2  the attribute's type is String
    *@return   return  the element {@odfLink draw:measure}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement createdrawMeasureElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement  nMeasure = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement.class);
        nMeasure.setX1( x1);
        nMeasure.setY1( y1);
        nMeasure.setX2( x2);
        nMeasure.setY2( y2);
        this.appendChild( nMeasure);
        return  nMeasure;      
    }
    
    /**
    * Create child element {@odfLink draw:caption}.
    *
    *@return   return  the element {@odfLink draw:caption}
    */
    public OdfCaptionElement createCaptionElement()
    {
        OdfCaptionElement  nCaption = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCaptionElement.class);
        this.appendChild( nCaption);
        return  nCaption;
    }                   
               
    /**
    * Create child element {@odfLink draw:connector}.
    *
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:connector}
    */
    public OdfConnectorElement createConnectorElement(Integer   viewBox)
    {
        OdfConnectorElement  nConnector = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectorElement.class);
        nConnector.setViewBox( viewBox);
        this.appendChild( nConnector);
        return  nConnector;      
    }
    
    /**
    * Create child element {@odfLink draw:control}.
    *
    *@param control  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink draw:control}
    */
    public OdfControlElement createControlElement(org.odftoolkit.odfdom.dom.type.OdfId   control)
    {
        OdfControlElement  nControl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfControlElement.class);
        nControl.setControl( control);
        this.appendChild( nControl);
        return  nControl;      
    }
    
    /**
    * Create child element {@odfLink dr3d:scene}.
    *
    *@return   return  the element {@odfLink dr3d:scene}
    */
    public OdfSceneElement createSceneElement()
    {
        OdfSceneElement  nScene = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSceneElement.class);
        this.appendChild( nScene);
        return  nScene;
    }                   
               
    /**
    * Create child element {@odfLink draw:custom-shape}.
    *
    *@return   return  the element {@odfLink draw:custom-shape}
    */
    public OdfCustomShapeElement createCustomShapeElement()
    {
        OdfCustomShapeElement  nCustomShape = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCustomShapeElement.class);
        this.appendChild( nCustomShape);
        return  nCustomShape;
    }                   
               
    /**
    * Create child element {@odfLink draw:a}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink draw:a}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement createdrawHyperlinkElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement  nHyperlink = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement.class);
        nHyperlink.setHref( href);
        this.appendChild( nHyperlink);
        return  nHyperlink;      
    }
    
    /**
    * Create child element {@odfLink text:date}.
    *
    *@return   return  the element {@odfLink text:date}
    */
    public OdfDateElement createDateElement()
    {
        OdfDateElement  nDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateElement.class);
        this.appendChild( nDate);
        return  nDate;
    }                   
               
    /**
    * Create child element {@odfLink text:time}.
    *
    *@return   return  the element {@odfLink text:time}
    */
    public OdfTimeElement createTimeElement()
    {
        OdfTimeElement  nTime = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTimeElement.class);
        this.appendChild( nTime);
        return  nTime;
    }                   
               
    /**
    * Create child element {@odfLink text:page-number}.
    *
    *@return   return  the element {@odfLink text:page-number}
    */
    public OdfPageNumberElement createPageNumberElement()
    {
        OdfPageNumberElement  nPageNumber = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageNumberElement.class);
        this.appendChild( nPageNumber);
        return  nPageNumber;
    }                   
               
    /**
    * Create child element {@odfLink text:page-continuation}.
    *
    *@param selectPage     the attribute's type is OdfPageContiuationSelectType, see {@attributeName  text:page-contiuation-select} at specification
    *@return   return  the element {@odfLink text:page-continuation}
    */
    public OdfPageContinuationElement createPageContinuationElement(OdfPageContiuationSelectType   selectPage)
    {
        OdfPageContinuationElement  nPageContinuation = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageContinuationElement.class);
        nPageContinuation.setSelectPage( selectPage);
        this.appendChild( nPageContinuation);
        return  nPageContinuation;      
    }
    
    /**
    * Create child element {@odfLink text:sender-firstname}.
    *
    *@return   return  the element {@odfLink text:sender-firstname}
    */
    public OdfSenderFirstnameElement createSenderFirstnameElement()
    {
        OdfSenderFirstnameElement  nSenderFirstname = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderFirstnameElement.class);
        this.appendChild( nSenderFirstname);
        return  nSenderFirstname;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-lastname}.
    *
    *@return   return  the element {@odfLink text:sender-lastname}
    */
    public OdfSenderLastnameElement createSenderLastnameElement()
    {
        OdfSenderLastnameElement  nSenderLastname = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderLastnameElement.class);
        this.appendChild( nSenderLastname);
        return  nSenderLastname;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-initials}.
    *
    *@return   return  the element {@odfLink text:sender-initials}
    */
    public OdfSenderInitialsElement createSenderInitialsElement()
    {
        OdfSenderInitialsElement  nSenderInitials = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderInitialsElement.class);
        this.appendChild( nSenderInitials);
        return  nSenderInitials;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-title}.
    *
    *@return   return  the element {@odfLink text:sender-title}
    */
    public OdfSenderTitleElement createSenderTitleElement()
    {
        OdfSenderTitleElement  nSenderTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderTitleElement.class);
        this.appendChild( nSenderTitle);
        return  nSenderTitle;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-position}.
    *
    *@return   return  the element {@odfLink text:sender-position}
    */
    public OdfSenderPositionElement createSenderPositionElement()
    {
        OdfSenderPositionElement  nSenderPosition = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderPositionElement.class);
        this.appendChild( nSenderPosition);
        return  nSenderPosition;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-email}.
    *
    *@return   return  the element {@odfLink text:sender-email}
    */
    public OdfSenderEmailElement createSenderEmailElement()
    {
        OdfSenderEmailElement  nSenderEmail = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderEmailElement.class);
        this.appendChild( nSenderEmail);
        return  nSenderEmail;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-phone-private}.
    *
    *@return   return  the element {@odfLink text:sender-phone-private}
    */
    public OdfSenderPhonePrivateElement createSenderPhonePrivateElement()
    {
        OdfSenderPhonePrivateElement  nSenderPhonePrivate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderPhonePrivateElement.class);
        this.appendChild( nSenderPhonePrivate);
        return  nSenderPhonePrivate;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-fax}.
    *
    *@return   return  the element {@odfLink text:sender-fax}
    */
    public OdfSenderFaxElement createSenderFaxElement()
    {
        OdfSenderFaxElement  nSenderFax = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderFaxElement.class);
        this.appendChild( nSenderFax);
        return  nSenderFax;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-company}.
    *
    *@return   return  the element {@odfLink text:sender-company}
    */
    public OdfSenderCompanyElement createSenderCompanyElement()
    {
        OdfSenderCompanyElement  nSenderCompany = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderCompanyElement.class);
        this.appendChild( nSenderCompany);
        return  nSenderCompany;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-phone-work}.
    *
    *@return   return  the element {@odfLink text:sender-phone-work}
    */
    public OdfSenderPhoneWorkElement createSenderPhoneWorkElement()
    {
        OdfSenderPhoneWorkElement  nSenderPhoneWork = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderPhoneWorkElement.class);
        this.appendChild( nSenderPhoneWork);
        return  nSenderPhoneWork;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-street}.
    *
    *@return   return  the element {@odfLink text:sender-street}
    */
    public OdfSenderStreetElement createSenderStreetElement()
    {
        OdfSenderStreetElement  nSenderStreet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderStreetElement.class);
        this.appendChild( nSenderStreet);
        return  nSenderStreet;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-city}.
    *
    *@return   return  the element {@odfLink text:sender-city}
    */
    public OdfSenderCityElement createSenderCityElement()
    {
        OdfSenderCityElement  nSenderCity = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderCityElement.class);
        this.appendChild( nSenderCity);
        return  nSenderCity;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-postal-code}.
    *
    *@return   return  the element {@odfLink text:sender-postal-code}
    */
    public OdfSenderPostalCodeElement createSenderPostalCodeElement()
    {
        OdfSenderPostalCodeElement  nSenderPostalCode = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderPostalCodeElement.class);
        this.appendChild( nSenderPostalCode);
        return  nSenderPostalCode;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-country}.
    *
    *@return   return  the element {@odfLink text:sender-country}
    */
    public OdfSenderCountryElement createSenderCountryElement()
    {
        OdfSenderCountryElement  nSenderCountry = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderCountryElement.class);
        this.appendChild( nSenderCountry);
        return  nSenderCountry;
    }                   
               
    /**
    * Create child element {@odfLink text:sender-state-or-province}.
    *
    *@return   return  the element {@odfLink text:sender-state-or-province}
    */
    public OdfSenderStateOrProvinceElement createSenderStateOrProvinceElement()
    {
        OdfSenderStateOrProvinceElement  nSenderStateOrProvince = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSenderStateOrProvinceElement.class);
        this.appendChild( nSenderStateOrProvince);
        return  nSenderStateOrProvince;
    }                   
               
    /**
    * Create child element {@odfLink text:author-name}.
    *
    *@return   return  the element {@odfLink text:author-name}
    */
    public OdfAuthorNameElement createAuthorNameElement()
    {
        OdfAuthorNameElement  nAuthorName = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAuthorNameElement.class);
        this.appendChild( nAuthorName);
        return  nAuthorName;
    }                   
               
    /**
    * Create child element {@odfLink text:author-initials}.
    *
    *@return   return  the element {@odfLink text:author-initials}
    */
    public OdfAuthorInitialsElement createAuthorInitialsElement()
    {
        OdfAuthorInitialsElement  nAuthorInitials = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAuthorInitialsElement.class);
        this.appendChild( nAuthorInitials);
        return  nAuthorInitials;
    }                   
               
    /**
    * Create child element {@odfLink text:chapter}.
    *
    *@param display     the attribute's type is OdfChapterDisplayType, see {@attributeName  text:chapter-display} at specification
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@return   return  the element {@odfLink text:chapter}
    */
    public OdfChapterElement createChapterElement(OdfChapterDisplayType   display, org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   outlineLevel)
    {
        OdfChapterElement  nChapter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChapterElement.class);
        nChapter.setDisplay( display);
        nChapter.setOutlineLevel( outlineLevel);
        this.appendChild( nChapter);
        return  nChapter;      
    }
    
    /**
    * Create child element {@odfLink text:file-name}.
    *
    *@return   return  the element {@odfLink text:file-name}
    */
    public OdfFileNameElement createFileNameElement()
    {
        OdfFileNameElement  nFileName = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFileNameElement.class);
        this.appendChild( nFileName);
        return  nFileName;
    }                   
               
    /**
    * Create child element {@odfLink text:template-name}.
    *
    *@return   return  the element {@odfLink text:template-name}
    */
    public OdfTemplateNameElement createTemplateNameElement()
    {
        OdfTemplateNameElement  nTemplateName = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTemplateNameElement.class);
        this.appendChild( nTemplateName);
        return  nTemplateName;
    }                   
               
    /**
    * Create child element {@odfLink text:sheet-name}.
    *
    *@return   return  the element {@odfLink text:sheet-name}
    */
    public OdfSheetNameElement createSheetNameElement()
    {
        OdfSheetNameElement  nSheetName = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSheetNameElement.class);
        this.appendChild( nSheetName);
        return  nSheetName;
    }                   
               
    /**
    * Create child element {@odfLink text:variable-set}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param value Double   
    *@param name String   
    *@return   return  the element {@odfLink text:variable-set}
    */
    public OdfVariableSetElement createVariableSetElement(OdfValueType   valueType, Double   value, String   name)
    {
        OdfVariableSetElement  nVariableSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableSetElement.class);
        nVariableSet.setValueType( valueType);
        nVariableSet.setValue( value);
        nVariableSet.setName( name);
        this.appendChild( nVariableSet);
        return  nVariableSet;      
    }
    
    /**
    * Create child element {@odfLink text:variable-set}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param dateValue    the attribute's type is XMLGregorianCalendar
    *@param name String   
    *@return   return  the element {@odfLink text:variable-set}
    */
    public OdfVariableSetElement createVariableSetElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDate   dateValue, String   name)
    {
        OdfVariableSetElement  nVariableSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableSetElement.class);
        nVariableSet.setValueType( valueType);
        nVariableSet.setDateValue( dateValue);
        nVariableSet.setName( name);
        this.appendChild( nVariableSet);
        return  nVariableSet;      
    }
    
    /**
    * Create child element {@odfLink text:variable-set}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param timeValue    the attribute's type is Duration
    *@param name String   
    *@return   return  the element {@odfLink text:variable-set}
    */
    public OdfVariableSetElement createVariableSetElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDuration   timeValue, String   name)
    {
        OdfVariableSetElement  nVariableSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableSetElement.class);
        nVariableSet.setValueType( valueType);
        nVariableSet.setTimeValue( timeValue);
        nVariableSet.setName( name);
        this.appendChild( nVariableSet);
        return  nVariableSet;      
    }
    
    /**
    * Create child element {@odfLink text:variable-set}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param booleanValue  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@param name String   
    *@return   return  the element {@odfLink text:variable-set}
    */
    public OdfVariableSetElement createVariableSetElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfBoolean   booleanValue, String   name)
    {
        OdfVariableSetElement  nVariableSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableSetElement.class);
        nVariableSet.setValueType( valueType);
        nVariableSet.setBooleanValue( booleanValue);
        nVariableSet.setName( name);
        this.appendChild( nVariableSet);
        return  nVariableSet;      
    }
    
    /**
    * Create child element {@odfLink text:variable-set}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param name String   
    *@return   return  the element {@odfLink text:variable-set}
    */
    public OdfVariableSetElement createVariableSetElement(OdfValueType   valueType, String   name)
    {
        OdfVariableSetElement  nVariableSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableSetElement.class);
        nVariableSet.setValueType( valueType);
        nVariableSet.setName( name);
        this.appendChild( nVariableSet);
        return  nVariableSet;      
    }
    
    /**
    * Create child element {@odfLink text:variable-get}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:variable-get}
    */
    public OdfVariableGetElement createVariableGetElement(String   name)
    {
        OdfVariableGetElement  nVariableGet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableGetElement.class);
        nVariableGet.setName( name);
        this.appendChild( nVariableGet);
        return  nVariableGet;      
    }
    
    /**
    * Create child element {@odfLink text:variable-input}.
    *
    *@param name String   
    *@param valueType     the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@return   return  the element {@odfLink text:variable-input}
    */
    public OdfVariableInputElement createVariableInputElement(String   name, OdfValueType   valueType)
    {
        OdfVariableInputElement  nVariableInput = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableInputElement.class);
        nVariableInput.setName( name);
        nVariableInput.setValueType( valueType);
        this.appendChild( nVariableInput);
        return  nVariableInput;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-get}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-get}
    */
    public OdfUserFieldGetElement createUserFieldGetElement(String   name)
    {
        OdfUserFieldGetElement  nUserFieldGet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldGetElement.class);
        nUserFieldGet.setName( name);
        this.appendChild( nUserFieldGet);
        return  nUserFieldGet;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-input}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-input}
    */
    public OdfUserFieldInputElement createUserFieldInputElement(String   name)
    {
        OdfUserFieldInputElement  nUserFieldInput = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldInputElement.class);
        nUserFieldInput.setName( name);
        this.appendChild( nUserFieldInput);
        return  nUserFieldInput;      
    }
    
    /**
    * Create child element {@odfLink text:sequence}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:sequence}
    */
    public OdfSequenceElement createSequenceElement(String   name)
    {
        OdfSequenceElement  nSequence = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSequenceElement.class);
        nSequence.setName( name);
        this.appendChild( nSequence);
        return  nSequence;      
    }
    
    /**
    * Create child element {@odfLink text:expression}.
    *
    *@return   return  the element {@odfLink text:expression}
    */
    public OdfExpressionElement createExpressionElement()
    {
        OdfExpressionElement  nExpression = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfExpressionElement.class);
        this.appendChild( nExpression);
        return  nExpression;
    }                   
               
    /**
    * Create child element {@odfLink text:text-input}.
    *
    *@return   return  the element {@odfLink text:text-input}
    */
    public OdfTextInputElement createTextInputElement()
    {
        OdfTextInputElement  nTextInput = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextInputElement.class);
        this.appendChild( nTextInput);
        return  nTextInput;
    }                   
               
    /**
    * Create child element {@odfLink text:initial-creator}.
    *
    *@return   return  the element {@odfLink text:initial-creator}
    */
    public OdfInitialCreatorElement createInitialCreatorElement()
    {
        OdfInitialCreatorElement  nInitialCreator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfInitialCreatorElement.class);
        this.appendChild( nInitialCreator);
        return  nInitialCreator;
    }                   
               
    /**
    * Create child element {@odfLink text:creation-date}.
    *
    *@return   return  the element {@odfLink text:creation-date}
    */
    public OdfCreationDateElement createCreationDateElement()
    {
        OdfCreationDateElement  nCreationDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCreationDateElement.class);
        this.appendChild( nCreationDate);
        return  nCreationDate;
    }                   
               
    /**
    * Create child element {@odfLink text:creation-time}.
    *
    *@return   return  the element {@odfLink text:creation-time}
    */
    public OdfCreationTimeElement createCreationTimeElement()
    {
        OdfCreationTimeElement  nCreationTime = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCreationTimeElement.class);
        this.appendChild( nCreationTime);
        return  nCreationTime;
    }                   
               
    /**
    * Create child element {@odfLink text:description}.
    *
    *@return   return  the element {@odfLink text:description}
    */
    public OdfDescriptionElement createDescriptionElement()
    {
        OdfDescriptionElement  nDescription = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescriptionElement.class);
        this.appendChild( nDescription);
        return  nDescription;
    }                   
               
    /**
    * Create child element {@odfLink text:user-defined}.
    *
    *@return   return  the element {@odfLink text:user-defined}
    */
    public OdfUserDefinedElement createUserDefinedElement()
    {
        OdfUserDefinedElement  nUserDefined = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserDefinedElement.class);
        this.appendChild( nUserDefined);
        return  nUserDefined;
    }                   
               
    /**
    * Create child element {@odfLink text:print-time}.
    *
    *@return   return  the element {@odfLink text:print-time}
    */
    public OdfPrintTimeElement createPrintTimeElement()
    {
        OdfPrintTimeElement  nPrintTime = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPrintTimeElement.class);
        this.appendChild( nPrintTime);
        return  nPrintTime;
    }                   
               
    /**
    * Create child element {@odfLink text:print-date}.
    *
    *@return   return  the element {@odfLink text:print-date}
    */
    public OdfPrintDateElement createPrintDateElement()
    {
        OdfPrintDateElement  nPrintDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPrintDateElement.class);
        this.appendChild( nPrintDate);
        return  nPrintDate;
    }                   
               
    /**
    * Create child element {@odfLink text:printed-by}.
    *
    *@return   return  the element {@odfLink text:printed-by}
    */
    public OdfPrintedByElement createPrintedByElement()
    {
        OdfPrintedByElement  nPrintedBy = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPrintedByElement.class);
        this.appendChild( nPrintedBy);
        return  nPrintedBy;
    }                   
               
    /**
    * Create child element {@odfLink text:title}.
    *
    *@return   return  the element {@odfLink text:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink text:subject}.
    *
    *@return   return  the element {@odfLink text:subject}
    */
    public OdfSubjectElement createSubjectElement()
    {
        OdfSubjectElement  nSubject = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSubjectElement.class);
        this.appendChild( nSubject);
        return  nSubject;
    }                   
               
    /**
    * Create child element {@odfLink text:keywords}.
    *
    *@return   return  the element {@odfLink text:keywords}
    */
    public OdfKeywordsElement createKeywordsElement()
    {
        OdfKeywordsElement  nKeywords = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfKeywordsElement.class);
        this.appendChild( nKeywords);
        return  nKeywords;
    }                   
               
    /**
    * Create child element {@odfLink text:editing-cycles}.
    *
    *@return   return  the element {@odfLink text:editing-cycles}
    */
    public OdfEditingCyclesElement createEditingCyclesElement()
    {
        OdfEditingCyclesElement  nEditingCycles = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEditingCyclesElement.class);
        this.appendChild( nEditingCycles);
        return  nEditingCycles;
    }                   
               
    /**
    * Create child element {@odfLink text:editing-duration}.
    *
    *@return   return  the element {@odfLink text:editing-duration}
    */
    public OdfEditingDurationElement createEditingDurationElement()
    {
        OdfEditingDurationElement  nEditingDuration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEditingDurationElement.class);
        this.appendChild( nEditingDuration);
        return  nEditingDuration;
    }                   
               
    /**
    * Create child element {@odfLink text:modification-time}.
    *
    *@return   return  the element {@odfLink text:modification-time}
    */
    public OdfModificationTimeElement createModificationTimeElement()
    {
        OdfModificationTimeElement  nModificationTime = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfModificationTimeElement.class);
        this.appendChild( nModificationTime);
        return  nModificationTime;
    }                   
               
    /**
    * Create child element {@odfLink text:modification-date}.
    *
    *@return   return  the element {@odfLink text:modification-date}
    */
    public OdfModificationDateElement createModificationDateElement()
    {
        OdfModificationDateElement  nModificationDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfModificationDateElement.class);
        this.appendChild( nModificationDate);
        return  nModificationDate;
    }                   
               
    /**
    * Create child element {@odfLink text:creator}.
    *
    *@return   return  the element {@odfLink text:creator}
    */
    public OdfCreatorElement createCreatorElement()
    {
        OdfCreatorElement  nCreator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCreatorElement.class);
        this.appendChild( nCreator);
        return  nCreator;
    }                   
               
    /**
    * Create child element {@odfLink text:database-display}.
    *
    *@param tableName String   
    *@param columnName String   
    *@return   return  the element {@odfLink text:database-display}
    */
    public OdfDatabaseDisplayElement createDatabaseDisplayElement(String   tableName, String   columnName)
    {
        OdfDatabaseDisplayElement  nDatabaseDisplay = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseDisplayElement.class);
        nDatabaseDisplay.setTableName( tableName);
        nDatabaseDisplay.setColumnName( columnName);
        this.appendChild( nDatabaseDisplay);
        return  nDatabaseDisplay;      
    }
    
    /**
    * Create child element {@odfLink text:database-next}.
    *
    *@param tableName String   
    *@return   return  the element {@odfLink text:database-next}
    */
    public OdfDatabaseNextElement createDatabaseNextElement(String   tableName)
    {
        OdfDatabaseNextElement  nDatabaseNext = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseNextElement.class);
        nDatabaseNext.setTableName( tableName);
        this.appendChild( nDatabaseNext);
        return  nDatabaseNext;      
    }
    
    /**
    * Create child element {@odfLink text:database-row-select}.
    *
    *@param tableName String   
    *@return   return  the element {@odfLink text:database-row-select}
    */
    public OdfDatabaseRowSelectElement createDatabaseRowSelectElement(String   tableName)
    {
        OdfDatabaseRowSelectElement  nDatabaseRowSelect = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseRowSelectElement.class);
        nDatabaseRowSelect.setTableName( tableName);
        this.appendChild( nDatabaseRowSelect);
        return  nDatabaseRowSelect;      
    }
    
    /**
    * Create child element {@odfLink text:database-row-number}.
    *
    *@param tableName String   
    *@return   return  the element {@odfLink text:database-row-number}
    */
    public OdfDatabaseRowNumberElement createDatabaseRowNumberElement(String   tableName)
    {
        OdfDatabaseRowNumberElement  nDatabaseRowNumber = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseRowNumberElement.class);
        nDatabaseRowNumber.setTableName( tableName);
        this.appendChild( nDatabaseRowNumber);
        return  nDatabaseRowNumber;      
    }
    
    /**
    * Create child element {@odfLink text:database-name}.
    *
    *@param tableName String   
    *@return   return  the element {@odfLink text:database-name}
    */
    public OdfDatabaseNameElement createDatabaseNameElement(String   tableName)
    {
        OdfDatabaseNameElement  nDatabaseName = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseNameElement.class);
        nDatabaseName.setTableName( tableName);
        this.appendChild( nDatabaseName);
        return  nDatabaseName;      
    }
    
    /**
    * Create child element {@odfLink text:page-variable-set}.
    *
    *@return   return  the element {@odfLink text:page-variable-set}
    */
    public OdfPageVariableSetElement createPageVariableSetElement()
    {
        OdfPageVariableSetElement  nPageVariableSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageVariableSetElement.class);
        this.appendChild( nPageVariableSet);
        return  nPageVariableSet;
    }                   
               
    /**
    * Create child element {@odfLink text:page-variable-get}.
    *
    *@return   return  the element {@odfLink text:page-variable-get}
    */
    public OdfPageVariableGetElement createPageVariableGetElement()
    {
        OdfPageVariableGetElement  nPageVariableGet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageVariableGetElement.class);
        this.appendChild( nPageVariableGet);
        return  nPageVariableGet;
    }                   
               
    /**
    * Create child element {@odfLink text:placeholder}.
    *
    *@param placeholderType   the attribute's type is OdfPlaceholderType, see {@attributeName  text:placeholder-type} at specification
    *@return   return  the element {@odfLink text:placeholder}
    */
    public OdfPlaceholderElement createPlaceholderElement(OdfPlaceholderType   placeholderType)
    {
        OdfPlaceholderElement  nPlaceholder = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPlaceholderElement.class);
        nPlaceholder.setPlaceholderType( placeholderType);
        this.appendChild( nPlaceholder);
        return  nPlaceholder;      
    }
    
    /**
    * Create child element {@odfLink text:conditional-text}.
    *
    *@param condition String   
    *@param stringValueIfTrue String   
    *@param stringValueIfFalse String   
    *@return   return  the element {@odfLink text:conditional-text}
    */
    public OdfConditionalTextElement createConditionalTextElement(String   condition, String   stringValueIfTrue, String   stringValueIfFalse)
    {
        OdfConditionalTextElement  nConditionalText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConditionalTextElement.class);
        nConditionalText.setCondition( condition);
        nConditionalText.setStringValueIfTrue( stringValueIfTrue);
        nConditionalText.setStringValueIfFalse( stringValueIfFalse);
        this.appendChild( nConditionalText);
        return  nConditionalText;      
    }
    
    /**
    * Create child element {@odfLink text:hidden-text}.
    *
    *@param condition String   
    *@param stringValue String   
    *@return   return  the element {@odfLink text:hidden-text}
    */
    public OdfHiddenTextElement createHiddenTextElement(String   condition, String   stringValue)
    {
        OdfHiddenTextElement  nHiddenText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHiddenTextElement.class);
        nHiddenText.setCondition( condition);
        nHiddenText.setStringValue( stringValue);
        this.appendChild( nHiddenText);
        return  nHiddenText;      
    }
    
    /**
    * Create child element {@odfLink text:note-ref}.
    *
    *@param noteClass     the attribute's type is OdfNoteClassType, see {@attributeName  text:note-class} at specification
    *@return   return  the element {@odfLink text:note-ref}
    */
    public OdfNoteRefElement createNoteRefElement(OdfNoteClassType   noteClass)
    {
        OdfNoteRefElement  nNoteRef = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNoteRefElement.class);
        nNoteRef.setNoteClass( noteClass);
        this.appendChild( nNoteRef);
        return  nNoteRef;      
    }
    
    /**
    * Create child element {@odfLink text:sequence-ref}.
    *
    *@return   return  the element {@odfLink text:sequence-ref}
    */
    public OdfSequenceRefElement createSequenceRefElement()
    {
        OdfSequenceRefElement  nSequenceRef = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSequenceRefElement.class);
        this.appendChild( nSequenceRef);
        return  nSequenceRef;
    }                   
               
    /**
    * Create child element {@odfLink text:script}.
    *
    *@return   return  the element {@odfLink text:script}
    */
    public OdfScriptElement createScriptElement()
    {
        OdfScriptElement  nScript = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfScriptElement.class);
        this.appendChild( nScript);
        return  nScript;
    }                   
               
    /**
    * Create child element {@odfLink text:execute-macro}.
    *
    *@return   return  the element {@odfLink text:execute-macro}
    */
    public OdfExecuteMacroElement createExecuteMacroElement()
    {
        OdfExecuteMacroElement  nExecuteMacro = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfExecuteMacroElement.class);
        this.appendChild( nExecuteMacro);
        return  nExecuteMacro;
    }                   
               
    /**
    * Create child element {@odfLink text:hidden-paragraph}.
    *
    *@param condition String   
    *@return   return  the element {@odfLink text:hidden-paragraph}
    */
    public OdfHiddenParagraphElement createHiddenParagraphElement(String   condition)
    {
        OdfHiddenParagraphElement  nHiddenParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHiddenParagraphElement.class);
        nHiddenParagraph.setCondition( condition);
        this.appendChild( nHiddenParagraph);
        return  nHiddenParagraph;      
    }
    
    /**
    * Create child element {@odfLink text:dde-connection}.
    *
    *@param connectionName String   
    *@return   return  the element {@odfLink text:dde-connection}
    */
    public OdfDdeConnectionElement createDdeConnectionElement(String   connectionName)
    {
        OdfDdeConnectionElement  nDdeConnection = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDdeConnectionElement.class);
        nDdeConnection.setConnectionName( connectionName);
        this.appendChild( nDdeConnection);
        return  nDdeConnection;      
    }
    
    /**
    * Create child element {@odfLink text:measure}.
    *
    *@param kind     the attribute's type is OdfKindType, see {@attributeName  text:kind} at specification
    *@return   return  the element {@odfLink text:measure}
    */
    public org.odftoolkit.odfdom.dom.element.text.OdfMeasureElement createtextMeasureElement(OdfKindType   kind)
    {
        org.odftoolkit.odfdom.dom.element.text.OdfMeasureElement  nMeasure = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.text.OdfMeasureElement.class);
        nMeasure.setKind( kind);
        this.appendChild( nMeasure);
        return  nMeasure;      
    }
    
    /**
    * Create child element {@odfLink text:table-formula}.
    *
    *@return   return  the element {@odfLink text:table-formula}
    */
    public OdfTableFormulaElement createTableFormulaElement()
    {
        OdfTableFormulaElement  nTableFormula = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableFormulaElement.class);
        this.appendChild( nTableFormula);
        return  nTableFormula;
    }                   
               
    /**
    * Create child element {@odfLink text:meta-field}.
    *
    *@param xmlid  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink text:meta-field}
    */
    public OdfMetaFieldElement createMetaFieldElement(org.odftoolkit.odfdom.dom.type.OdfId   xmlid)
    {
        OdfMetaFieldElement  nMetaField = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMetaFieldElement.class);
        nMetaField.setXmlid( xmlid);
        this.appendChild( nMetaField);
        return  nMetaField;      
    }
    
    /**
    * Create child element {@odfLink text:toc-mark-start}.
    *
    *@param id String   
    *@return   return  the element {@odfLink text:toc-mark-start}
    */
    public OdfTocMarkStartElement createTocMarkStartElement(String   id)
    {
        OdfTocMarkStartElement  nTocMarkStart = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTocMarkStartElement.class);
        nTocMarkStart.setId( id);
        this.appendChild( nTocMarkStart);
        return  nTocMarkStart;      
    }
    
    /**
    * Create child element {@odfLink text:toc-mark-end}.
    *
    *@param id String   
    *@return   return  the element {@odfLink text:toc-mark-end}
    */
    public OdfTocMarkEndElement createTocMarkEndElement(String   id)
    {
        OdfTocMarkEndElement  nTocMarkEnd = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTocMarkEndElement.class);
        nTocMarkEnd.setId( id);
        this.appendChild( nTocMarkEnd);
        return  nTocMarkEnd;      
    }
    
    /**
    * Create child element {@odfLink text:toc-mark}.
    *
    *@param stringValue String   
    *@return   return  the element {@odfLink text:toc-mark}
    */
    public OdfTocMarkElement createTocMarkElement(String   stringValue)
    {
        OdfTocMarkElement  nTocMark = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTocMarkElement.class);
        nTocMark.setStringValue( stringValue);
        this.appendChild( nTocMark);
        return  nTocMark;      
    }
    
    /**
    * Create child element {@odfLink text:user-index-mark-start}.
    *
    *@param id String   
    *@param indexName String   
    *@return   return  the element {@odfLink text:user-index-mark-start}
    */
    public OdfUserIndexMarkStartElement createUserIndexMarkStartElement(String   id, String   indexName)
    {
        OdfUserIndexMarkStartElement  nUserIndexMarkStart = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserIndexMarkStartElement.class);
        nUserIndexMarkStart.setId( id);
        nUserIndexMarkStart.setIndexName( indexName);
        this.appendChild( nUserIndexMarkStart);
        return  nUserIndexMarkStart;      
    }
    
    /**
    * Create child element {@odfLink text:user-index-mark-end}.
    *
    *@param id String   
    *@return   return  the element {@odfLink text:user-index-mark-end}
    */
    public OdfUserIndexMarkEndElement createUserIndexMarkEndElement(String   id)
    {
        OdfUserIndexMarkEndElement  nUserIndexMarkEnd = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserIndexMarkEndElement.class);
        nUserIndexMarkEnd.setId( id);
        this.appendChild( nUserIndexMarkEnd);
        return  nUserIndexMarkEnd;      
    }
    
    /**
    * Create child element {@odfLink text:user-index-mark}.
    *
    *@param stringValue String   
    *@param indexName String   
    *@return   return  the element {@odfLink text:user-index-mark}
    */
    public OdfUserIndexMarkElement createUserIndexMarkElement(String   stringValue, String   indexName)
    {
        OdfUserIndexMarkElement  nUserIndexMark = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserIndexMarkElement.class);
        nUserIndexMark.setStringValue( stringValue);
        nUserIndexMark.setIndexName( indexName);
        this.appendChild( nUserIndexMark);
        return  nUserIndexMark;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index-mark-start}.
    *
    *@param id String   
    *@return   return  the element {@odfLink text:alphabetical-index-mark-start}
    */
    public OdfAlphabeticalIndexMarkStartElement createAlphabeticalIndexMarkStartElement(String   id)
    {
        OdfAlphabeticalIndexMarkStartElement  nAlphabeticalIndexMarkStart = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexMarkStartElement.class);
        nAlphabeticalIndexMarkStart.setId( id);
        this.appendChild( nAlphabeticalIndexMarkStart);
        return  nAlphabeticalIndexMarkStart;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index-mark-end}.
    *
    *@param id String   
    *@return   return  the element {@odfLink text:alphabetical-index-mark-end}
    */
    public OdfAlphabeticalIndexMarkEndElement createAlphabeticalIndexMarkEndElement(String   id)
    {
        OdfAlphabeticalIndexMarkEndElement  nAlphabeticalIndexMarkEnd = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexMarkEndElement.class);
        nAlphabeticalIndexMarkEnd.setId( id);
        this.appendChild( nAlphabeticalIndexMarkEnd);
        return  nAlphabeticalIndexMarkEnd;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index-mark}.
    *
    *@param stringValue String   
    *@return   return  the element {@odfLink text:alphabetical-index-mark}
    */
    public OdfAlphabeticalIndexMarkElement createAlphabeticalIndexMarkElement(String   stringValue)
    {
        OdfAlphabeticalIndexMarkElement  nAlphabeticalIndexMark = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexMarkElement.class);
        nAlphabeticalIndexMark.setStringValue( stringValue);
        this.appendChild( nAlphabeticalIndexMark);
        return  nAlphabeticalIndexMark;      
    }
    
    /**
    * Create child element {@odfLink text:bibliography-mark}.
    *
    *@param bibliographyType   the attribute's type is OdfBibliographyType, see {@attributeName  text:bibliography-type} at specification
    *@return   return  the element {@odfLink text:bibliography-mark}
    */
    public OdfBibliographyMarkElement createBibliographyMarkElement(OdfBibliographyType   bibliographyType)
    {
        OdfBibliographyMarkElement  nBibliographyMark = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBibliographyMarkElement.class);
        nBibliographyMark.setBibliographyType( bibliographyType);
        this.appendChild( nBibliographyMark);
        return  nBibliographyMark;      
    }
    
    /**
    * Create child element {@odfLink presentation:header}.
    *
    *@return   return  the element {@odfLink presentation:header}
    */
    public OdfHeaderElement createHeaderElement()
    {
        OdfHeaderElement  nHeader = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHeaderElement.class);
        this.appendChild( nHeader);
        return  nHeader;
    }                   
               
    /**
    * Create child element {@odfLink presentation:footer}.
    *
    *@return   return  the element {@odfLink presentation:footer}
    */
    public OdfFooterElement createFooterElement()
    {
        OdfFooterElement  nFooter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFooterElement.class);
        this.appendChild( nFooter);
        return  nFooter;
    }                   
               
    /**
    * Create child element {@odfLink presentation:date-time}.
    *
    *@return   return  the element {@odfLink presentation:date-time}
    */
    public OdfDateTimeElement createDateTimeElement()
    {
        OdfDateTimeElement  nDateTime = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDateTimeElement.class);
        this.appendChild( nDateTime);
        return  nDateTime;
    }                   
               
}
