/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:list-style}.
 *
 */
public abstract class OdfListStyleElement extends OdfStyleBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "list-style" );

    /**
     * Create the instance of OdfListStyleElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfListStyleElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:list-style}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfListStyleElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *
     */
    public void init(OdfStyleName name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName style:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display-name" ), displayName );
    }

    /**
     * Get value of attribute {@attributeName text:consecutive-numbering}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getConsecutiveNumbering()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "consecutive-numbering" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:consecutive-numbering}.
     *
     *@param  isConsecutiveNumbering    the attribute's type is OdfBoolean
     */ 
     public void setConsecutiveNumbering( OdfBoolean isConsecutiveNumbering )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "consecutive-numbering" ), isConsecutiveNumbering.toString() );
    }

    /**
    * Create child element {@odfLink text:list-level-style-number}.
    *
    *@param level  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param numFormat String   
    *@return   return  the element {@odfLink text:list-level-style-number}
    */
    public OdfListLevelStyleNumberElement createListLevelStyleNumberElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   level, String   numFormat)
    {
        OdfListLevelStyleNumberElement  nListLevelStyleNumber = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListLevelStyleNumberElement.class);
        nListLevelStyleNumber.setLevel( level);
        nListLevelStyleNumber.setNumFormat( numFormat);
        this.appendChild( nListLevelStyleNumber);
        return  nListLevelStyleNumber;      
    }
    
    /**
    * Create child element {@odfLink text:list-level-style-number}.
    *
    *@param numFormat   the attribute's type is String
    *@param level  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:list-level-style-number}
    */
    public OdfListLevelStyleNumberElement createListLevelStyleNumberElement(String   numFormat, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   level)
    {
        OdfListLevelStyleNumberElement  nListLevelStyleNumber = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListLevelStyleNumberElement.class);
        nListLevelStyleNumber.setNumFormat( numFormat);
        nListLevelStyleNumber.setLevel( level);
        this.appendChild( nListLevelStyleNumber);
        return  nListLevelStyleNumber;      
    }
    
    /**
    * Create child element {@odfLink text:list-level-style-bullet}.
    *
    *@param level  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param bulletChar String   
    *@return   return  the element {@odfLink text:list-level-style-bullet}
    */
    public OdfListLevelStyleBulletElement createListLevelStyleBulletElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   level, String   bulletChar)
    {
        OdfListLevelStyleBulletElement  nListLevelStyleBullet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListLevelStyleBulletElement.class);
        nListLevelStyleBullet.setLevel( level);
        nListLevelStyleBullet.setBulletChar( bulletChar);
        this.appendChild( nListLevelStyleBullet);
        return  nListLevelStyleBullet;      
    }
    
    /**
    * Create child element {@odfLink text:list-level-style-image}.
    *
    *@param level  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:list-level-style-image}
    */
    public OdfListLevelStyleImageElement createListLevelStyleImageElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   level)
    {
        OdfListLevelStyleImageElement  nListLevelStyleImage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListLevelStyleImageElement.class);
        nListLevelStyleImage.setLevel( level);
        this.appendChild( nListLevelStyleImage);
        return  nListLevelStyleImage;      
    }
    
}
