/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;

import org.odftoolkit.odfdom.dom.element.style.OdfListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfTextPropertiesElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:list-level-style-number}.
 *
 */
public abstract class OdfListLevelStyleNumberElement extends OdfListLevelStyleElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "list-level-style-number" );

    /**
     * Create the instance of OdfListLevelStyleNumberElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfListLevelStyleNumberElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:list-level-style-number}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfListLevelStyleNumberElement}
     *
     *@param numFormat  The mandatory attribute {@attributeName  style:num-format}" 
     **@param level  The mandatory attribute {@attributeName  text:level}" 
     *
     */
    public void init(String numFormat, OdfPositiveInteger level)
    {
        setNumFormat( numFormat );
        super.init( level );
    }

    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:num-format}.
     *
     *@return return the attribute which type is String
     */
    public String getNumFormat()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-format" ) );
    }

    /**
     * Set value of attribute {@attributeName style:num-format}.
     *
     *@param  numFormat    the attribute's type is String
     */ 
     public void setNumFormat( String numFormat )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-format" ), numFormat );
    }

    /**
     * Get value of attribute {@attributeName style:num-letter-sync}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getNumLetterSync()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-letter-sync" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:num-letter-sync}.
     *
     *@param  isNumLetterSync    the attribute's type is OdfBoolean
     */ 
     public void setNumLetterSync( OdfBoolean isNumLetterSync )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-letter-sync" ), isNumLetterSync.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:num-prefix}.
     *
     *@return return the attribute which type is String
     */
    public String getNumPrefix()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-prefix" ) );
    }

    /**
     * Set value of attribute {@attributeName style:num-prefix}.
     *
     *@param  numPrefix    the attribute's type is String
     */ 
     public void setNumPrefix( String numPrefix )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-prefix" ), numPrefix );
    }

    /**
     * Get value of attribute {@attributeName style:num-suffix}.
     *
     *@return return the attribute which type is String
     */
    public String getNumSuffix()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-suffix" ) );
    }

    /**
     * Set value of attribute {@attributeName style:num-suffix}.
     *
     *@param  numSuffix    the attribute's type is String
     */ 
     public void setNumSuffix( String numSuffix )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-suffix" ), numSuffix );
    }

    /**
     * Get value of attribute {@attributeName text:display-levels}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getDisplayLevels()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "display-levels" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1";
        }

        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:display-levels}.
     *
     *@param  displayLevels    the attribute's type is OdfPositiveInteger
     */ 
     public void setDisplayLevels( OdfPositiveInteger displayLevels )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "display-levels" ), displayLevels.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:start-value}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getStartValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "start-value" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1";
        }

        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:start-value}.
     *
     *@param  startValue    the attribute's type is OdfPositiveInteger
     */ 
     public void setStartValue( OdfPositiveInteger startValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "start-value" ), startValue.toString() );
    }

    /**
    * Create child element {@odfLink style:list-level-properties}.
    *
    *@return   return  the element {@odfLink style:list-level-properties}
    */
    public OdfListLevelPropertiesElement createListLevelPropertiesElement()
    {
        OdfListLevelPropertiesElement  nListLevelProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListLevelPropertiesElement.class);
        this.appendChild( nListLevelProperties);
        return  nListLevelProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:text-properties}.
    *
    *@param display String   
    *@return   return  the element {@odfLink style:text-properties}
    */
    public OdfTextPropertiesElement createTextPropertiesElement(String   display)
    {
        OdfTextPropertiesElement  nTextProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextPropertiesElement.class);
        this.appendChild( nTextProperties);
        return  nTextProperties;      
    }
    
    /**
    * Create child element {@odfLink style:text-properties}.
    *
    *@param display String   
    *@param condition String   
    *@return   return  the element {@odfLink style:text-properties}
    */
    public OdfTextPropertiesElement createTextPropertiesElement(String   display, String   condition)
    {
        OdfTextPropertiesElement  nTextProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextPropertiesElement.class);
        this.appendChild( nTextProperties);
        return  nTextProperties;      
    }
    
}
