/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    
package org.odftoolkit.odfdom.dom.element.text;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;


/**
 * DOM implementation of OpenDocument base element 
 */
public abstract class OdfListLevelStyleElementBase extends OdfStyleBase
{
    /**
     * Create the instance of OdfListLevelStyleElementBase 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     *@param  element_name   The type is OdfName
     */
    public OdfListLevelStyleElementBase( OdfFileDom aOwnerDoc, OdfName element_name )
    {
        super( aOwnerDoc, element_name );
    }
    /**
     * Initialization of the mandatory attributes of {@link  OdfListLevelStyleElementBase}
     *
     *@param level  The mandatory attribute {@attributeName  text:level}" 
     *
     */
    public void init(OdfPositiveInteger level)
    {
        setLevel( level );
    }
      
    /**
     * Get value of attribute {@attributeName text:level}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "level" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:level}.
     *
     *@param  level    the attribute's type is OdfPositiveInteger
     */ 
     public void setLevel( OdfPositiveInteger level )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "level" ), level.toString() );
    }

}
      