/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfId;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:list}.
 *
 */
public abstract class OdfListElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "list" );

    /**
     * Create the instance of OdfListElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfListElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:list}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:continue-numbering}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getContinueNumbering()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "continue-numbering" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:continue-numbering}.
     *
     *@param  isContinueNumbering    the attribute's type is OdfBoolean
     */ 
     public void setContinueNumbering( OdfBoolean isContinueNumbering )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "continue-numbering" ), isContinueNumbering.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:continue-list}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getContinueList()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "continue-list" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:continue-list}.
     *
     *@param  continueList    the attribute's type is OdfId
     */ 
     public void setContinueList( OdfId continueList )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "continue-list" ), continueList.toString() );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink text:list-header}.
    *
    *@return   return  the element {@odfLink text:list-header}
    */
    public OdfListHeaderElement createListHeaderElement()
    {
        OdfListHeaderElement  nListHeader = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListHeaderElement.class);
        this.appendChild( nListHeader);
        return  nListHeader;
    }                   
               
    /**
    * Create child element {@odfLink text:list-item}.
    *
    *@return   return  the element {@odfLink text:list-item}
    */
    public OdfListItemElement createListItemElement()
    {
        OdfListItemElement  nListItem = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListItemElement.class);
        this.appendChild( nListItem);
        return  nListItem;
    }                   
               
}
