/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.text.OdfNumberPositionType;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:linenumbering-configuration}.
 *
 */
public abstract class OdfLinenumberingConfigurationElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "linenumbering-configuration" );

    /**
     * Create the instance of OdfLinenumberingConfigurationElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfLinenumberingConfigurationElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Text, OdfName.get( OdfNamespace.TEXT, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:linenumbering-configuration}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:number-lines}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getNumberLines()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "number-lines" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:number-lines}.
     *
     *@param  isNumberLines    the attribute's type is OdfBoolean
     */ 
     public void setNumberLines( OdfBoolean isNumberLines )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "number-lines" ), isNumberLines.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:num-format}.
     *
     *@return return the attribute which type is String
     */
    public String getNumFormat()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-format" ) );
    }

    /**
     * Set value of attribute {@attributeName style:num-format}.
     *
     *@param  numFormat    the attribute's type is String
     */ 
     public void setNumFormat( String numFormat )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-format" ), numFormat );
    }

    /**
     * Get value of attribute {@attributeName style:num-letter-sync}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getNumLetterSync()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-letter-sync" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:num-letter-sync}.
     *
     *@param  isNumLetterSync    the attribute's type is OdfBoolean
     */ 
     public void setNumLetterSync( OdfBoolean isNumLetterSync )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-letter-sync" ), isNumLetterSync.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:increment}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getIncrement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "increment" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:increment}.
     *
     *@param  increment    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setIncrement( OdfNonNegativeInteger increment )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "increment" ), increment.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:number-position}.
     *
     *@return return the attribute which type is OdfNumberPositionType
     */
    public OdfNumberPositionType getNumberPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "number-position" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "left";
        }

        return OdfNumberPositionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:number-position}.
     *
     *@param  numberPosition    the attribute's type is OdfNumberPositionType
     */ 
     public void setNumberPosition( OdfNumberPositionType numberPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "number-position" ), numberPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:offset}.
     *
     *@return return the attribute which type is OdfNonNegativeLength
     */
    public OdfNonNegativeLength getOffset()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "offset" ) );
        return OdfNonNegativeLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:offset}.
     *
     *@param  offset    the attribute's type is OdfNonNegativeLength
     */ 
     public void setOffset( OdfNonNegativeLength offset )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "offset" ), offset.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:count-empty-lines}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCountEmptyLines()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "count-empty-lines" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:count-empty-lines}.
     *
     *@param  isCountEmptyLines    the attribute's type is OdfBoolean
     */ 
     public void setCountEmptyLines( OdfBoolean isCountEmptyLines )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "count-empty-lines" ), isCountEmptyLines.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:count-in-text-boxes}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCountInTextBoxes()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "count-in-text-boxes" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:count-in-text-boxes}.
     *
     *@param  isCountInTextBoxes    the attribute's type is OdfBoolean
     */ 
     public void setCountInTextBoxes( OdfBoolean isCountInTextBoxes )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "count-in-text-boxes" ), isCountInTextBoxes.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:restart-on-page}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRestartOnPage()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "restart-on-page" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:restart-on-page}.
     *
     *@param  isRestartOnPage    the attribute's type is OdfBoolean
     */ 
     public void setRestartOnPage( OdfBoolean isRestartOnPage )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "restart-on-page" ), isRestartOnPage.toString() );
    }

    /**
    * Create child element {@odfLink text:linenumbering-separator}.
    *
    *@return   return  the element {@odfLink text:linenumbering-separator}
    */
    public OdfLinenumberingSeparatorElement createLinenumberingSeparatorElement()
    {
        OdfLinenumberingSeparatorElement  nLinenumberingSeparator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLinenumberingSeparatorElement.class);
        this.appendChild( nLinenumberingSeparator);
        return  nLinenumberingSeparator;
    }                   
               
}
