/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.style.OdfIndexTabStopType;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:index-entry-tab-stop}.
 *
 */
public abstract class OdfIndexEntryTabStopElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "index-entry-tab-stop" );

    /**
     * Create the instance of OdfIndexEntryTabStopElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfIndexEntryTabStopElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Text, OdfName.get( OdfNamespace.TEXT, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:index-entry-tab-stop}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:leader-char}.
     *
     *@return return the attribute which type is String
     */
    public String getLeaderChar()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-char" ) );
    }

    /**
     * Set value of attribute {@attributeName style:leader-char}.
     *
     *@param  leaderChar    the attribute's type is String
     */ 
     public void setLeaderChar( String leaderChar )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-char" ), leaderChar );
    }

    /**
     * Get value of attribute {@attributeName style:type}.
     *
     *@return return the attribute which type is OdfIndexTabStopType
     */
    public OdfIndexTabStopType getType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "type" ) );
        return OdfIndexTabStopType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:type}.
     *
     *@param  type    the attribute's type is OdfIndexTabStopType
     */ 
     public void setType( OdfIndexTabStopType type )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "type" ), type.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:position}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "position" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:position}.
     *
     *@param  position    the attribute's type is OdfLength
     */ 
     public void setPosition( OdfLength position )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "position" ), position.toString() );
    }

}
