/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfIndexScopeType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.text.OdfCaptionSequenceFormatType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:illustration-index-source}.
 *
 */
public abstract class OdfIllustrationIndexSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "illustration-index-source" );

    /**
     * Create the instance of OdfIllustrationIndexSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfIllustrationIndexSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:illustration-index-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:index-scope}.
     *
     *@return return the attribute which type is OdfIndexScopeType
     */
    public OdfIndexScopeType getIndexScope()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "document";
        }

        return OdfIndexScopeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:index-scope}.
     *
     *@param  indexScope    the attribute's type is OdfIndexScopeType
     */ 
     public void setIndexScope( OdfIndexScopeType indexScope )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ), indexScope.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRelativeTabStopPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@param  isRelativeTabStopPosition    the attribute's type is OdfBoolean
     */ 
     public void setRelativeTabStopPosition( OdfBoolean isRelativeTabStopPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ), isRelativeTabStopPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-caption}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseCaption()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-caption" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-caption}.
     *
     *@param  isUseCaption    the attribute's type is OdfBoolean
     */ 
     public void setUseCaption( OdfBoolean isUseCaption )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-caption" ), isUseCaption.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:caption-sequence-name}.
     *
     *@return return the attribute which type is String
     */
    public String getCaptionSequenceName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "caption-sequence-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:caption-sequence-name}.
     *
     *@param  captionSequenceName    the attribute's type is String
     */ 
     public void setCaptionSequenceName( String captionSequenceName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "caption-sequence-name" ), captionSequenceName );
    }

    /**
     * Get value of attribute {@attributeName text:caption-sequence-format}.
     *
     *@return return the attribute which type is OdfCaptionSequenceFormatType
     */
    public OdfCaptionSequenceFormatType getCaptionSequenceFormat()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "caption-sequence-format" ) );
        return OdfCaptionSequenceFormatType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:caption-sequence-format}.
     *
     *@param  captionSequenceFormat    the attribute's type is OdfCaptionSequenceFormatType
     */ 
     public void setCaptionSequenceFormat( OdfCaptionSequenceFormatType captionSequenceFormat )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "caption-sequence-format" ), captionSequenceFormat.toString() );
    }

    /**
    * Create child element {@odfLink text:index-title-template}.
    *
    *@return   return  the element {@odfLink text:index-title-template}
    */
    public OdfIndexTitleTemplateElement createIndexTitleTemplateElement()
    {
        OdfIndexTitleTemplateElement  nIndexTitleTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexTitleTemplateElement.class);
        this.appendChild( nIndexTitleTemplate);
        return  nIndexTitleTemplate;
    }                   
               
    /**
    * Create child element {@odfLink text:illustration-index-entry-template}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink text:illustration-index-entry-template}
    */
    public OdfIllustrationIndexEntryTemplateElement createIllustrationIndexEntryTemplateElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfIllustrationIndexEntryTemplateElement  nIllustrationIndexEntryTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIllustrationIndexEntryTemplateElement.class);
        nIllustrationIndexEntryTemplate.setStyleName( styleName);
        this.appendChild( nIllustrationIndexEntryTemplate);
        return  nIllustrationIndexEntryTemplate;      
    }
    
}
