/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:hidden-text}.
 *
 */
public abstract class OdfHiddenTextElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "hidden-text" );

    /**
     * Create the instance of OdfHiddenTextElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfHiddenTextElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:hidden-text}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfHiddenTextElement}
     *
     *@param condition  The mandatory attribute {@attributeName  text:condition}" 
     *@param stringValue  The mandatory attribute {@attributeName  text:string-value}" 
     *
     */
    public void init(String condition, String stringValue)
    {
        setCondition( condition );
        setStringValue( stringValue );
    }

    /**
     * Get value of attribute {@attributeName text:condition}.
     *
     *@return return the attribute which type is String
     */
    public String getCondition()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "condition" ) );
    }

    /**
     * Set value of attribute {@attributeName text:condition}.
     *
     *@param  condition    the attribute's type is String
     */ 
     public void setCondition( String condition )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "condition" ), condition );
    }

    /**
     * Get value of attribute {@attributeName text:string-value}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value" ) );
    }

    /**
     * Set value of attribute {@attributeName text:string-value}.
     *
     *@param  stringValue    the attribute's type is String
     */ 
     public void setStringValue( String stringValue )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value" ), stringValue );
    }

    /**
     * Get value of attribute {@attributeName text:is-hidden}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsHidden()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "is-hidden" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:is-hidden}.
     *
     *@param  isIsHidden    the attribute's type is OdfBoolean
     */ 
     public void setIsHidden( OdfBoolean isIsHidden )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "is-hidden" ), isIsHidden.toString() );
    }

}
