/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:dde-connection}.
 *
 */
public abstract class OdfDdeConnectionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "dde-connection" );

    /**
     * Create the instance of OdfDdeConnectionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDdeConnectionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:dde-connection}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDdeConnectionElement}
     *
     *@param connectionName  The mandatory attribute {@attributeName  text:connection-name}" 
     *
     */
    public void init(String connectionName)
    {
        setConnectionName( connectionName );
    }

    /**
     * Get value of attribute {@attributeName text:connection-name}.
     *
     *@return return the attribute which type is String
     */
    public String getConnectionName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "connection-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:connection-name}.
     *
     *@param  connectionName    the attribute's type is String
     */ 
     public void setConnectionName( String connectionName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "connection-name" ), connectionName );
    }

}
