/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:dde-connection-decls}.
 *
 */
public abstract class OdfDdeConnectionDeclsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "dde-connection-decls" );

    /**
     * Create the instance of OdfDdeConnectionDeclsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDdeConnectionDeclsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:dde-connection-decls}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink text:dde-connection-decl}.
    *
    *@param name String   
    *@param ddeApplication String   
    *@param ddeTopic String   
    *@param ddeItem String   
    *@return   return  the element {@odfLink text:dde-connection-decl}
    */
    public OdfDdeConnectionDeclElement createDdeConnectionDeclElement(String   name, String   ddeApplication, String   ddeTopic, String   ddeItem)
    {
        OdfDdeConnectionDeclElement  nDdeConnectionDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDdeConnectionDeclElement.class);
        nDdeConnectionDecl.setName( name);
        nDdeConnectionDecl.setDdeApplication( ddeApplication);
        nDdeConnectionDecl.setDdeTopic( ddeTopic);
        nDdeConnectionDecl.setDdeItem( ddeItem);
        this.appendChild( nDdeConnectionDecl);
        return  nDdeConnectionDecl;      
    }
    
}
