/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfTableType;

import org.odftoolkit.odfdom.dom.element.form.OdfConnectionResourceElement;
import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:database-name}.
 *
 */
public abstract class OdfDatabaseNameElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "database-name" );

    /**
     * Create the instance of OdfDatabaseNameElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDatabaseNameElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:database-name}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDatabaseNameElement}
     *
     *@param tableName  The mandatory attribute {@attributeName  text:table-name}" 
     *
     */
    public void init(String tableName)
    {
        setTableName( tableName );
    }

    /**
     * Get value of attribute {@attributeName text:table-name}.
     *
     *@return return the attribute which type is String
     */
    public String getTableName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "table-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:table-name}.
     *
     *@param  tableName    the attribute's type is String
     */ 
     public void setTableName( String tableName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "table-name" ), tableName );
    }

    /**
     * Get value of attribute {@attributeName text:table-type}.
     *
     *@return return the attribute which type is OdfTableType
     */
    public OdfTableType getTableType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "table-type" ) );
        return OdfTableType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:table-type}.
     *
     *@param  tableType    the attribute's type is OdfTableType
     */ 
     public void setTableType( OdfTableType tableType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "table-type" ), tableType.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:database-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDatabaseName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "database-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:database-name}.
     *
     *@param  databaseName    the attribute's type is String
     */ 
     public void setDatabaseName( String databaseName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "database-name" ), databaseName );
    }

    /**
    * Create child element {@odfLink form:connection-resource}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink form:connection-resource}
    */
    public OdfConnectionResourceElement createConnectionResourceElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfConnectionResourceElement  nConnectionResource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectionResourceElement.class);
        nConnectionResource.setHref( href);
        this.appendChild( nConnectionResource);
        return  nConnectionResource;      
    }
    
}
