/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import javax.xml.datatype.XMLGregorianCalendar;
import org.odftoolkit.odfdom.dom.type.OdfDate;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:creation-time}.
 *
 */
public abstract class OdfCreationTimeElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "creation-time" );

    /**
     * Create the instance of OdfCreationTimeElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCreationTimeElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:creation-time}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:fixed}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getFixed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "fixed" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:fixed}.
     *
     *@param  isFixed    the attribute's type is OdfBoolean
     */ 
     public void setFixed( OdfBoolean isFixed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "fixed" ), isFixed.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:data-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDataStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "data-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:data-style-name}.
     *
     *@param  dataStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDataStyleName( OdfStyleNameRef dataStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "data-style-name" ), dataStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:time-value}.
     *
     *@return return the attribute which type is OdfDate
     */
    public OdfDate getTimeValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "time-value" ) );
        return OdfDate.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:time-value}.
     *
     *@param  timeValue    the attribute's type is OdfDate
     */ 
     public void setTimeValue( OdfDate timeValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "time-value" ), timeValue.toString() );
    }

}
