/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:conditional-text}.
 *
 */
public abstract class OdfConditionalTextElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "conditional-text" );

    /**
     * Create the instance of OdfConditionalTextElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfConditionalTextElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:conditional-text}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfConditionalTextElement}
     *
     *@param condition  The mandatory attribute {@attributeName  text:condition}" 
     *@param stringValueIfTrue  The mandatory attribute {@attributeName  text:string-value-if-true}" 
     *@param stringValueIfFalse  The mandatory attribute {@attributeName  text:string-value-if-false}" 
     *
     */
    public void init(String condition, String stringValueIfTrue, String stringValueIfFalse)
    {
        setCondition( condition );
        setStringValueIfTrue( stringValueIfTrue );
        setStringValueIfFalse( stringValueIfFalse );
    }

    /**
     * Get value of attribute {@attributeName text:condition}.
     *
     *@return return the attribute which type is String
     */
    public String getCondition()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "condition" ) );
    }

    /**
     * Set value of attribute {@attributeName text:condition}.
     *
     *@param  condition    the attribute's type is String
     */ 
     public void setCondition( String condition )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "condition" ), condition );
    }

    /**
     * Get value of attribute {@attributeName text:string-value-if-true}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValueIfTrue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value-if-true" ) );
    }

    /**
     * Set value of attribute {@attributeName text:string-value-if-true}.
     *
     *@param  stringValueIfTrue    the attribute's type is String
     */ 
     public void setStringValueIfTrue( String stringValueIfTrue )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value-if-true" ), stringValueIfTrue );
    }

    /**
     * Get value of attribute {@attributeName text:string-value-if-false}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValueIfFalse()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value-if-false" ) );
    }

    /**
     * Set value of attribute {@attributeName text:string-value-if-false}.
     *
     *@param  stringValueIfFalse    the attribute's type is String
     */ 
     public void setStringValueIfFalse( String stringValueIfFalse )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value-if-false" ), stringValueIfFalse );
    }

    /**
     * Get value of attribute {@attributeName text:current-value}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCurrentValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "current-value" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:current-value}.
     *
     *@param  isCurrentValue    the attribute's type is OdfBoolean
     */ 
     public void setCurrentValue( OdfBoolean isCurrentValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "current-value" ), isCurrentValue.toString() );
    }

}
