/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfChapterDisplayType;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:chapter}.
 *
 */
public abstract class OdfChapterElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "chapter" );

    /**
     * Create the instance of OdfChapterElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfChapterElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:chapter}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfChapterElement}
     *
     *@param display  The mandatory attribute {@attributeName  text:display}" 
     *@param outlineLevel  The mandatory attribute {@attributeName  text:outline-level}" 
     *
     */
    public void init(OdfChapterDisplayType display, OdfNonNegativeInteger outlineLevel)
    {
        setDisplay( display );
        setOutlineLevel( outlineLevel );
    }

    /**
     * Get value of attribute {@attributeName text:display}.
     *
     *@return return the attribute which type is OdfChapterDisplayType
     */
    public OdfChapterDisplayType getDisplay()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "display" ) );
        return OdfChapterDisplayType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:display}.
     *
     *@param  display    the attribute's type is OdfChapterDisplayType
     */ 
     public void setDisplay( OdfChapterDisplayType display )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "display" ), display.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:outline-level}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getOutlineLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:outline-level}.
     *
     *@param  outlineLevel    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setOutlineLevel( OdfNonNegativeInteger outlineLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ), outlineLevel.toString() );
    }

}
