/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfId;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:changed-region}.
 *
 */
public abstract class OdfChangedRegionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "changed-region" );

    /**
     * Create the instance of OdfChangedRegionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfChangedRegionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:changed-region}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfChangedRegionElement}
     *
     *@param id  The mandatory attribute {@attributeName  text:id}" 
     *@param xmlid  The mandatory attribute {@attributeName  xml:xmlid}" 
     *
     */
    public void init(String id, OdfId xmlid)
    {
        setId( id );
        setXmlid( xmlid );
    }

    /**
     * Get value of attribute {@attributeName text:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName text:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink text:insertion}.
    *
    *@return   return  the element {@odfLink text:insertion}
    */
    public OdfInsertionElement createInsertionElement()
    {
        OdfInsertionElement  nInsertion = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfInsertionElement.class);
        this.appendChild( nInsertion);
        return  nInsertion;
    }                   
               
    /**
    * Create child element {@odfLink text:deletion}.
    *
    *@return   return  the element {@odfLink text:deletion}
    */
    public OdfDeletionElement createDeletionElement()
    {
        OdfDeletionElement  nDeletion = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDeletionElement.class);
        this.appendChild( nDeletion);
        return  nDeletion;
    }                   
               
    /**
    * Create child element {@odfLink text:format-change}.
    *
    *@return   return  the element {@odfLink text:format-change}
    */
    public OdfFormatChangeElement createFormatChangeElement()
    {
        OdfFormatChangeElement  nFormatChange = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormatChangeElement.class);
        this.appendChild( nFormatChange);
        return  nFormatChange;
    }                   
               
}
