/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfBibliographyType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:bibliography-mark}.
 *
 */
public abstract class OdfBibliographyMarkElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "bibliography-mark" );

    /**
     * Create the instance of OdfBibliographyMarkElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfBibliographyMarkElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:bibliography-mark}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfBibliographyMarkElement}
     *
     *@param bibliographyType  The mandatory attribute {@attributeName  text:bibliography-type}" 
     *@param identifier  The mandatory attribute {@attributeName  text:identifier}" 
     *@param address  The mandatory attribute {@attributeName  text:address}" 
     *@param annote  The mandatory attribute {@attributeName  text:annote}" 
     *@param author  The mandatory attribute {@attributeName  text:author}" 
     *@param booktitle  The mandatory attribute {@attributeName  text:booktitle}" 
     *@param chapter  The mandatory attribute {@attributeName  text:chapter}" 
     *@param edition  The mandatory attribute {@attributeName  text:edition}" 
     *@param editor  The mandatory attribute {@attributeName  text:editor}" 
     *@param howpublished  The mandatory attribute {@attributeName  text:howpublished}" 
     *@param institution  The mandatory attribute {@attributeName  text:institution}" 
     *@param journal  The mandatory attribute {@attributeName  text:journal}" 
     *@param month  The mandatory attribute {@attributeName  text:month}" 
     *@param note  The mandatory attribute {@attributeName  text:note}" 
     *@param number  The mandatory attribute {@attributeName  text:number}" 
     *@param organizations  The mandatory attribute {@attributeName  text:organizations}" 
     *@param pages  The mandatory attribute {@attributeName  text:pages}" 
     *@param publisher  The mandatory attribute {@attributeName  text:publisher}" 
     *@param school  The mandatory attribute {@attributeName  text:school}" 
     *@param series  The mandatory attribute {@attributeName  text:series}" 
     *@param title  The mandatory attribute {@attributeName  text:title}" 
     *@param reportType  The mandatory attribute {@attributeName  text:report-type}" 
     *@param volume  The mandatory attribute {@attributeName  text:volume}" 
     *@param year  The mandatory attribute {@attributeName  text:year}" 
     *@param url  The mandatory attribute {@attributeName  text:url}" 
     *@param custom1  The mandatory attribute {@attributeName  text:custom1}" 
     *@param custom2  The mandatory attribute {@attributeName  text:custom2}" 
     *@param custom3  The mandatory attribute {@attributeName  text:custom3}" 
     *@param custom4  The mandatory attribute {@attributeName  text:custom4}" 
     *@param custom5  The mandatory attribute {@attributeName  text:custom5}" 
     *@param isbn  The mandatory attribute {@attributeName  text:isbn}" 
     *@param issn  The mandatory attribute {@attributeName  text:issn}" 
     *
     */
    public void init(OdfBibliographyType bibliographyType, String identifier, String address, String annote, String author, String booktitle, String chapter, String edition, String editor, String howpublished, String institution, String journal, String month, String note, String number, String organizations, String pages, String publisher, String school, String series, String title, String reportType, String volume, String year, String url, String custom1, String custom2, String custom3, String custom4, String custom5, String isbn, String issn)
    {
        setBibliographyType( bibliographyType );
        setIdentifier( identifier );
        setAddress( address );
        setAnnote( annote );
        setAuthor( author );
        setBooktitle( booktitle );
        setChapter( chapter );
        setEdition( edition );
        setEditor( editor );
        setHowpublished( howpublished );
        setInstitution( institution );
        setJournal( journal );
        setMonth( month );
        setNote( note );
        setNumber( number );
        setOrganizations( organizations );
        setPages( pages );
        setPublisher( publisher );
        setSchool( school );
        setSeries( series );
        setTitle( title );
        setReportType( reportType );
        setVolume( volume );
        setYear( year );
        setUrl( url );
        setCustom1( custom1 );
        setCustom2( custom2 );
        setCustom3( custom3 );
        setCustom4( custom4 );
        setCustom5( custom5 );
        setIsbn( isbn );
        setIssn( issn );
    }

    /**
     * Get value of attribute {@attributeName text:bibliography-type}.
     *
     *@return return the attribute which type is OdfBibliographyType
     */
    public OdfBibliographyType getBibliographyType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "bibliography-type" ) );
        return OdfBibliographyType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:bibliography-type}.
     *
     *@param  bibliographyType    the attribute's type is OdfBibliographyType
     */ 
     public void setBibliographyType( OdfBibliographyType bibliographyType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "bibliography-type" ), bibliographyType.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:identifier}.
     *
     *@return return the attribute which type is String
     */
    public String getIdentifier()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "identifier" ) );
    }

    /**
     * Set value of attribute {@attributeName text:identifier}.
     *
     *@param  identifier    the attribute's type is String
     */ 
     public void setIdentifier( String identifier )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "identifier" ), identifier );
    }

    /**
     * Get value of attribute {@attributeName text:address}.
     *
     *@return return the attribute which type is String
     */
    public String getAddress()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "address" ) );
    }

    /**
     * Set value of attribute {@attributeName text:address}.
     *
     *@param  address    the attribute's type is String
     */ 
     public void setAddress( String address )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "address" ), address );
    }

    /**
     * Get value of attribute {@attributeName text:annote}.
     *
     *@return return the attribute which type is String
     */
    public String getAnnote()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "annote" ) );
    }

    /**
     * Set value of attribute {@attributeName text:annote}.
     *
     *@param  annote    the attribute's type is String
     */ 
     public void setAnnote( String annote )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "annote" ), annote );
    }

    /**
     * Get value of attribute {@attributeName text:author}.
     *
     *@return return the attribute which type is String
     */
    public String getAuthor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "author" ) );
    }

    /**
     * Set value of attribute {@attributeName text:author}.
     *
     *@param  author    the attribute's type is String
     */ 
     public void setAuthor( String author )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "author" ), author );
    }

    /**
     * Get value of attribute {@attributeName text:booktitle}.
     *
     *@return return the attribute which type is String
     */
    public String getBooktitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "booktitle" ) );
    }

    /**
     * Set value of attribute {@attributeName text:booktitle}.
     *
     *@param  booktitle    the attribute's type is String
     */ 
     public void setBooktitle( String booktitle )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "booktitle" ), booktitle );
    }

    /**
     * Get value of attribute {@attributeName text:chapter}.
     *
     *@return return the attribute which type is String
     */
    public String getChapter()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "chapter" ) );
    }

    /**
     * Set value of attribute {@attributeName text:chapter}.
     *
     *@param  chapter    the attribute's type is String
     */ 
     public void setChapter( String chapter )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "chapter" ), chapter );
    }

    /**
     * Get value of attribute {@attributeName text:edition}.
     *
     *@return return the attribute which type is String
     */
    public String getEdition()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "edition" ) );
    }

    /**
     * Set value of attribute {@attributeName text:edition}.
     *
     *@param  edition    the attribute's type is String
     */ 
     public void setEdition( String edition )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "edition" ), edition );
    }

    /**
     * Get value of attribute {@attributeName text:editor}.
     *
     *@return return the attribute which type is String
     */
    public String getEditor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "editor" ) );
    }

    /**
     * Set value of attribute {@attributeName text:editor}.
     *
     *@param  editor    the attribute's type is String
     */ 
     public void setEditor( String editor )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "editor" ), editor );
    }

    /**
     * Get value of attribute {@attributeName text:howpublished}.
     *
     *@return return the attribute which type is String
     */
    public String getHowpublished()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "howpublished" ) );
    }

    /**
     * Set value of attribute {@attributeName text:howpublished}.
     *
     *@param  howpublished    the attribute's type is String
     */ 
     public void setHowpublished( String howpublished )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "howpublished" ), howpublished );
    }

    /**
     * Get value of attribute {@attributeName text:institution}.
     *
     *@return return the attribute which type is String
     */
    public String getInstitution()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "institution" ) );
    }

    /**
     * Set value of attribute {@attributeName text:institution}.
     *
     *@param  institution    the attribute's type is String
     */ 
     public void setInstitution( String institution )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "institution" ), institution );
    }

    /**
     * Get value of attribute {@attributeName text:journal}.
     *
     *@return return the attribute which type is String
     */
    public String getJournal()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "journal" ) );
    }

    /**
     * Set value of attribute {@attributeName text:journal}.
     *
     *@param  journal    the attribute's type is String
     */ 
     public void setJournal( String journal )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "journal" ), journal );
    }

    /**
     * Get value of attribute {@attributeName text:month}.
     *
     *@return return the attribute which type is String
     */
    public String getMonth()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "month" ) );
    }

    /**
     * Set value of attribute {@attributeName text:month}.
     *
     *@param  month    the attribute's type is String
     */ 
     public void setMonth( String month )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "month" ), month );
    }

    /**
     * Get value of attribute {@attributeName text:note}.
     *
     *@return return the attribute which type is String
     */
    public String getNote()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "note" ) );
    }

    /**
     * Set value of attribute {@attributeName text:note}.
     *
     *@param  note    the attribute's type is String
     */ 
     public void setNote( String note )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "note" ), note );
    }

    /**
     * Get value of attribute {@attributeName text:number}.
     *
     *@return return the attribute which type is String
     */
    public String getNumber()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "number" ) );
    }

    /**
     * Set value of attribute {@attributeName text:number}.
     *
     *@param  number    the attribute's type is String
     */ 
     public void setNumber( String number )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "number" ), number );
    }

    /**
     * Get value of attribute {@attributeName text:organizations}.
     *
     *@return return the attribute which type is String
     */
    public String getOrganizations()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "organizations" ) );
    }

    /**
     * Set value of attribute {@attributeName text:organizations}.
     *
     *@param  organizations    the attribute's type is String
     */ 
     public void setOrganizations( String organizations )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "organizations" ), organizations );
    }

    /**
     * Get value of attribute {@attributeName text:pages}.
     *
     *@return return the attribute which type is String
     */
    public String getPages()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "pages" ) );
    }

    /**
     * Set value of attribute {@attributeName text:pages}.
     *
     *@param  pages    the attribute's type is String
     */ 
     public void setPages( String pages )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "pages" ), pages );
    }

    /**
     * Get value of attribute {@attributeName text:publisher}.
     *
     *@return return the attribute which type is String
     */
    public String getPublisher()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "publisher" ) );
    }

    /**
     * Set value of attribute {@attributeName text:publisher}.
     *
     *@param  publisher    the attribute's type is String
     */ 
     public void setPublisher( String publisher )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "publisher" ), publisher );
    }

    /**
     * Get value of attribute {@attributeName text:school}.
     *
     *@return return the attribute which type is String
     */
    public String getSchool()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "school" ) );
    }

    /**
     * Set value of attribute {@attributeName text:school}.
     *
     *@param  school    the attribute's type is String
     */ 
     public void setSchool( String school )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "school" ), school );
    }

    /**
     * Get value of attribute {@attributeName text:series}.
     *
     *@return return the attribute which type is String
     */
    public String getSeries()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "series" ) );
    }

    /**
     * Set value of attribute {@attributeName text:series}.
     *
     *@param  series    the attribute's type is String
     */ 
     public void setSeries( String series )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "series" ), series );
    }

    /**
     * Get value of attribute {@attributeName text:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName text:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName text:report-type}.
     *
     *@return return the attribute which type is String
     */
    public String getReportType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "report-type" ) );
    }

    /**
     * Set value of attribute {@attributeName text:report-type}.
     *
     *@param  reportType    the attribute's type is String
     */ 
     public void setReportType( String reportType )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "report-type" ), reportType );
    }

    /**
     * Get value of attribute {@attributeName text:volume}.
     *
     *@return return the attribute which type is String
     */
    public String getVolume()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "volume" ) );
    }

    /**
     * Set value of attribute {@attributeName text:volume}.
     *
     *@param  volume    the attribute's type is String
     */ 
     public void setVolume( String volume )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "volume" ), volume );
    }

    /**
     * Get value of attribute {@attributeName text:year}.
     *
     *@return return the attribute which type is String
     */
    public String getYear()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "year" ) );
    }

    /**
     * Set value of attribute {@attributeName text:year}.
     *
     *@param  year    the attribute's type is String
     */ 
     public void setYear( String year )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "year" ), year );
    }

    /**
     * Get value of attribute {@attributeName text:url}.
     *
     *@return return the attribute which type is String
     */
    public String getUrl()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "url" ) );
    }

    /**
     * Set value of attribute {@attributeName text:url}.
     *
     *@param  url    the attribute's type is String
     */ 
     public void setUrl( String url )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "url" ), url );
    }

    /**
     * Get value of attribute {@attributeName text:custom1}.
     *
     *@return return the attribute which type is String
     */
    public String getCustom1()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom1" ) );
    }

    /**
     * Set value of attribute {@attributeName text:custom1}.
     *
     *@param  custom1    the attribute's type is String
     */ 
     public void setCustom1( String custom1 )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom1" ), custom1 );
    }

    /**
     * Get value of attribute {@attributeName text:custom2}.
     *
     *@return return the attribute which type is String
     */
    public String getCustom2()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom2" ) );
    }

    /**
     * Set value of attribute {@attributeName text:custom2}.
     *
     *@param  custom2    the attribute's type is String
     */ 
     public void setCustom2( String custom2 )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom2" ), custom2 );
    }

    /**
     * Get value of attribute {@attributeName text:custom3}.
     *
     *@return return the attribute which type is String
     */
    public String getCustom3()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom3" ) );
    }

    /**
     * Set value of attribute {@attributeName text:custom3}.
     *
     *@param  custom3    the attribute's type is String
     */ 
     public void setCustom3( String custom3 )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom3" ), custom3 );
    }

    /**
     * Get value of attribute {@attributeName text:custom4}.
     *
     *@return return the attribute which type is String
     */
    public String getCustom4()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom4" ) );
    }

    /**
     * Set value of attribute {@attributeName text:custom4}.
     *
     *@param  custom4    the attribute's type is String
     */ 
     public void setCustom4( String custom4 )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom4" ), custom4 );
    }

    /**
     * Get value of attribute {@attributeName text:custom5}.
     *
     *@return return the attribute which type is String
     */
    public String getCustom5()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom5" ) );
    }

    /**
     * Set value of attribute {@attributeName text:custom5}.
     *
     *@param  custom5    the attribute's type is String
     */ 
     public void setCustom5( String custom5 )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "custom5" ), custom5 );
    }

    /**
     * Get value of attribute {@attributeName text:isbn}.
     *
     *@return return the attribute which type is String
     */
    public String getIsbn()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "isbn" ) );
    }

    /**
     * Set value of attribute {@attributeName text:isbn}.
     *
     *@param  isbn    the attribute's type is String
     */ 
     public void setIsbn( String isbn )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "isbn" ), isbn );
    }

    /**
     * Get value of attribute {@attributeName text:issn}.
     *
     *@return return the attribute which type is String
     */
    public String getIssn()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "issn" ) );
    }

    /**
     * Set value of attribute {@attributeName text:issn}.
     *
     *@param  issn    the attribute's type is String
     */ 
     public void setIssn( String issn )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "issn" ), issn );
    }

}
