/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

import org.odftoolkit.odfdom.dom.type.text.OdfKeyType;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:bibliography-configuration}.
 *
 */
public abstract class OdfBibliographyConfigurationElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "bibliography-configuration" );

    /**
     * Create the instance of OdfBibliographyConfigurationElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfBibliographyConfigurationElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:bibliography-configuration}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:prefix}.
     *
     *@return return the attribute which type is String
     */
    public String getPrefixText()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "prefix" ) );
    }

    /**
     * Set value of attribute {@attributeName text:prefix}.
     *
     *@param  prefixText    the attribute's type is String
     */ 
     public void setPrefixText( String prefixText )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "prefix" ), prefixText );
    }

    /**
     * Get value of attribute {@attributeName text:suffix}.
     *
     *@return return the attribute which type is String
     */
    public String getSuffixText()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "suffix" ) );
    }

    /**
     * Set value of attribute {@attributeName text:suffix}.
     *
     *@param  suffixText    the attribute's type is String
     */ 
     public void setSuffixText( String suffixText )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "suffix" ), suffixText );
    }

    /**
     * Get value of attribute {@attributeName text:numbered-entries}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getNumberedEntries()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "numbered-entries" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:numbered-entries}.
     *
     *@param  isNumberedEntries    the attribute's type is OdfBoolean
     */ 
     public void setNumberedEntries( OdfBoolean isNumberedEntries )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "numbered-entries" ), isNumberedEntries.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:sort-by-position}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getSortByPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "sort-by-position" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:sort-by-position}.
     *
     *@param  isSortByPosition    the attribute's type is OdfBoolean
     */ 
     public void setSortByPosition( OdfBoolean isSortByPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "sort-by-position" ), isSortByPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName fo:language}.
     *
     *@return return the attribute which type is String
     */
    public String getLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FO, "language" ) );
    }

    /**
     * Set value of attribute {@attributeName fo:language}.
     *
     *@param  language    the attribute's type is String
     */ 
     public void setLanguage( String language )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "language" ), language );
    }

    /**
     * Get value of attribute {@attributeName fo:country}.
     *
     *@return return the attribute which type is String
     */
    public String getCountry()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FO, "country" ) );
    }

    /**
     * Set value of attribute {@attributeName fo:country}.
     *
     *@param  country    the attribute's type is String
     */ 
     public void setCountry( String country )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "country" ), country );
    }

    /**
     * Get value of attribute {@attributeName fo:script}.
     *
     *@return return the attribute which type is String
     */
    public String getScript()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FO, "script" ) );
    }

    /**
     * Set value of attribute {@attributeName fo:script}.
     *
     *@param  script    the attribute's type is String
     */ 
     public void setScript( String script )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "script" ), script );
    }

    /**
     * Get value of attribute {@attributeName style:rfc-language-tag}.
     *
     *@return return the attribute which type is String
     */
    public String getRfcLanguageTag()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rfc-language-tag" ) );
    }

    /**
     * Set value of attribute {@attributeName style:rfc-language-tag}.
     *
     *@param  rfcLanguageTag    the attribute's type is String
     */ 
     public void setRfcLanguageTag( String rfcLanguageTag )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rfc-language-tag" ), rfcLanguageTag );
    }

    /**
     * Get value of attribute {@attributeName text:sort-algorithm}.
     *
     *@return return the attribute which type is String
     */
    public String getSortAlgorithm()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "sort-algorithm" ) );
    }

    /**
     * Set value of attribute {@attributeName text:sort-algorithm}.
     *
     *@param  sortAlgorithm    the attribute's type is String
     */ 
     public void setSortAlgorithm( String sortAlgorithm )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "sort-algorithm" ), sortAlgorithm );
    }

    /**
    * Create child element {@odfLink text:sort-key}.
    *
    *@param key     the attribute's type is OdfKeyType, see {@attributeName  text:key} at specification
    *@return   return  the element {@odfLink text:sort-key}
    */
    public OdfSortKeyElement createSortKeyElement(OdfKeyType   key)
    {
        OdfSortKeyElement  nSortKey = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSortKeyElement.class);
        nSortKey.setKey( key);
        this.appendChild( nSortKey);
        return  nSortKey;      
    }
    
}
