/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfIndexScopeType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

import org.odftoolkit.odfdom.dom.type.text.OdfOutlineLevelType;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:alphabetical-index-source}.
 *
 */
public abstract class OdfAlphabeticalIndexSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "alphabetical-index-source" );

    /**
     * Create the instance of OdfAlphabeticalIndexSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAlphabeticalIndexSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:alphabetical-index-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:index-scope}.
     *
     *@return return the attribute which type is OdfIndexScopeType
     */
    public OdfIndexScopeType getIndexScope()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "document";
        }

        return OdfIndexScopeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:index-scope}.
     *
     *@param  indexScope    the attribute's type is OdfIndexScopeType
     */ 
     public void setIndexScope( OdfIndexScopeType indexScope )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ), indexScope.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRelativeTabStopPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@param  isRelativeTabStopPosition    the attribute's type is OdfBoolean
     */ 
     public void setRelativeTabStopPosition( OdfBoolean isRelativeTabStopPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ), isRelativeTabStopPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:ignore-case}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIgnoreCase()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "ignore-case" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:ignore-case}.
     *
     *@param  isIgnoreCase    the attribute's type is OdfBoolean
     */ 
     public void setIgnoreCase( OdfBoolean isIgnoreCase )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "ignore-case" ), isIgnoreCase.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:main-entry-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getMainEntryStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "main-entry-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:main-entry-style-name}.
     *
     *@param  mainEntryStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setMainEntryStyleName( OdfStyleNameRef mainEntryStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "main-entry-style-name" ), mainEntryStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:alphabetical-separators}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAlphabeticalSeparators()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "alphabetical-separators" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:alphabetical-separators}.
     *
     *@param  isAlphabeticalSeparators    the attribute's type is OdfBoolean
     */ 
     public void setAlphabeticalSeparators( OdfBoolean isAlphabeticalSeparators )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "alphabetical-separators" ), isAlphabeticalSeparators.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:combine-entries}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCombineEntries()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "combine-entries" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:combine-entries}.
     *
     *@param  isCombineEntries    the attribute's type is OdfBoolean
     */ 
     public void setCombineEntries( OdfBoolean isCombineEntries )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "combine-entries" ), isCombineEntries.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:combine-entries-with-dash}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCombineEntriesWithDash()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "combine-entries-with-dash" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:combine-entries-with-dash}.
     *
     *@param  isCombineEntriesWithDash    the attribute's type is OdfBoolean
     */ 
     public void setCombineEntriesWithDash( OdfBoolean isCombineEntriesWithDash )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "combine-entries-with-dash" ), isCombineEntriesWithDash.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:combine-entries-with-pp}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCombineEntriesWithPp()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "combine-entries-with-pp" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:combine-entries-with-pp}.
     *
     *@param  isCombineEntriesWithPp    the attribute's type is OdfBoolean
     */ 
     public void setCombineEntriesWithPp( OdfBoolean isCombineEntriesWithPp )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "combine-entries-with-pp" ), isCombineEntriesWithPp.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-keys-as-entries}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseKeysAsEntries()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-keys-as-entries" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-keys-as-entries}.
     *
     *@param  isUseKeysAsEntries    the attribute's type is OdfBoolean
     */ 
     public void setUseKeysAsEntries( OdfBoolean isUseKeysAsEntries )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-keys-as-entries" ), isUseKeysAsEntries.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:capitalize-entries}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCapitalizeEntries()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "capitalize-entries" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:capitalize-entries}.
     *
     *@param  isCapitalizeEntries    the attribute's type is OdfBoolean
     */ 
     public void setCapitalizeEntries( OdfBoolean isCapitalizeEntries )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "capitalize-entries" ), isCapitalizeEntries.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:comma-separated}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCommaSeparated()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "comma-separated" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:comma-separated}.
     *
     *@param  isCommaSeparated    the attribute's type is OdfBoolean
     */ 
     public void setCommaSeparated( OdfBoolean isCommaSeparated )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "comma-separated" ), isCommaSeparated.toString() );
    }

    /**
     * Get value of attribute {@attributeName fo:language}.
     *
     *@return return the attribute which type is String
     */
    public String getLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FO, "language" ) );
    }

    /**
     * Set value of attribute {@attributeName fo:language}.
     *
     *@param  language    the attribute's type is String
     */ 
     public void setLanguage( String language )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "language" ), language );
    }

    /**
     * Get value of attribute {@attributeName fo:country}.
     *
     *@return return the attribute which type is String
     */
    public String getCountry()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FO, "country" ) );
    }

    /**
     * Set value of attribute {@attributeName fo:country}.
     *
     *@param  country    the attribute's type is String
     */ 
     public void setCountry( String country )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "country" ), country );
    }

    /**
     * Get value of attribute {@attributeName fo:script}.
     *
     *@return return the attribute which type is String
     */
    public String getScript()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.FO, "script" ) );
    }

    /**
     * Set value of attribute {@attributeName fo:script}.
     *
     *@param  script    the attribute's type is String
     */ 
     public void setScript( String script )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "script" ), script );
    }

    /**
     * Get value of attribute {@attributeName style:rfc-language-tag}.
     *
     *@return return the attribute which type is String
     */
    public String getRfcLanguageTag()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rfc-language-tag" ) );
    }

    /**
     * Set value of attribute {@attributeName style:rfc-language-tag}.
     *
     *@param  rfcLanguageTag    the attribute's type is String
     */ 
     public void setRfcLanguageTag( String rfcLanguageTag )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rfc-language-tag" ), rfcLanguageTag );
    }

    /**
     * Get value of attribute {@attributeName text:sort-algorithm}.
     *
     *@return return the attribute which type is String
     */
    public String getSortAlgorithm()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "sort-algorithm" ) );
    }

    /**
     * Set value of attribute {@attributeName text:sort-algorithm}.
     *
     *@param  sortAlgorithm    the attribute's type is String
     */ 
     public void setSortAlgorithm( String sortAlgorithm )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "sort-algorithm" ), sortAlgorithm );
    }

    /**
    * Create child element {@odfLink text:index-title-template}.
    *
    *@return   return  the element {@odfLink text:index-title-template}
    */
    public OdfIndexTitleTemplateElement createIndexTitleTemplateElement()
    {
        OdfIndexTitleTemplateElement  nIndexTitleTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexTitleTemplateElement.class);
        this.appendChild( nIndexTitleTemplate);
        return  nIndexTitleTemplate;
    }                   
               
    /**
    * Create child element {@odfLink text:alphabetical-index-entry-template}.
    *
    *@param outlineLevel     the attribute's type is OdfOutlineLevelType, see {@attributeName  text:outline-level} at specification
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink text:alphabetical-index-entry-template}
    */
    public OdfAlphabeticalIndexEntryTemplateElement createAlphabeticalIndexEntryTemplateElement(OdfOutlineLevelType   outlineLevel, org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfAlphabeticalIndexEntryTemplateElement  nAlphabeticalIndexEntryTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexEntryTemplateElement.class);
        nAlphabeticalIndexEntryTemplate.setOutlineLevel( outlineLevel);
        nAlphabeticalIndexEntryTemplate.setStyleName( styleName);
        this.appendChild( nAlphabeticalIndexEntryTemplate);
        return  nAlphabeticalIndexEntryTemplate;      
    }
    
}
