/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:alphabetical-index-mark-start}.
 *
 */
public abstract class OdfAlphabeticalIndexMarkStartElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "alphabetical-index-mark-start" );

    /**
     * Create the instance of OdfAlphabeticalIndexMarkStartElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAlphabeticalIndexMarkStartElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:alphabetical-index-mark-start}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfAlphabeticalIndexMarkStartElement}
     *
     *@param id  The mandatory attribute {@attributeName  text:id}" 
     *
     */
    public void init(String id)
    {
        setId( id );
    }

    /**
     * Get value of attribute {@attributeName text:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName text:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName text:key1}.
     *
     *@return return the attribute which type is String
     */
    public String getKey1()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key1" ) );
    }

    /**
     * Set value of attribute {@attributeName text:key1}.
     *
     *@param  key1    the attribute's type is String
     */ 
     public void setKey1( String key1 )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key1" ), key1 );
    }

    /**
     * Get value of attribute {@attributeName text:key2}.
     *
     *@return return the attribute which type is String
     */
    public String getKey2()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key2" ) );
    }

    /**
     * Set value of attribute {@attributeName text:key2}.
     *
     *@param  key2    the attribute's type is String
     */ 
     public void setKey2( String key2 )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key2" ), key2 );
    }

    /**
     * Get value of attribute {@attributeName text:string-value-phonetic}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValuePhonetic()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value-phonetic" ) );
    }

    /**
     * Set value of attribute {@attributeName text:string-value-phonetic}.
     *
     *@param  stringValuePhonetic    the attribute's type is String
     */ 
     public void setStringValuePhonetic( String stringValuePhonetic )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value-phonetic" ), stringValuePhonetic );
    }

    /**
     * Get value of attribute {@attributeName text:key1-phonetic}.
     *
     *@return return the attribute which type is String
     */
    public String getKey1Phonetic()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key1-phonetic" ) );
    }

    /**
     * Set value of attribute {@attributeName text:key1-phonetic}.
     *
     *@param  key1Phonetic    the attribute's type is String
     */ 
     public void setKey1Phonetic( String key1Phonetic )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key1-phonetic" ), key1Phonetic );
    }

    /**
     * Get value of attribute {@attributeName text:key2-phonetic}.
     *
     *@return return the attribute which type is String
     */
    public String getKey2Phonetic()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key2-phonetic" ) );
    }

    /**
     * Set value of attribute {@attributeName text:key2-phonetic}.
     *
     *@param  key2Phonetic    the attribute's type is String
     */ 
     public void setKey2Phonetic( String key2Phonetic )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key2-phonetic" ), key2Phonetic );
    }

    /**
     * Get value of attribute {@attributeName text:main-entry}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getMainEntry()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "main-entry" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:main-entry}.
     *
     *@param  isMainEntry    the attribute's type is OdfBoolean
     */ 
     public void setMainEntry( OdfBoolean isMainEntry )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "main-entry" ), isMainEntry.toString() );
    }

}
