/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.text.OdfOutlineLevelType;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

import org.odftoolkit.odfdom.dom.type.style.OdfIndexTabStopType;
import org.odftoolkit.odfdom.dom.type.style.OdfIndexTabStopType;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:alphabetical-index-entry-template}.
 *
 */
public abstract class OdfAlphabeticalIndexEntryTemplateElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "alphabetical-index-entry-template" );

    /**
     * Create the instance of OdfAlphabeticalIndexEntryTemplateElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAlphabeticalIndexEntryTemplateElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Paragraph, OdfName.get( OdfNamespace.TEXT, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:alphabetical-index-entry-template}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfAlphabeticalIndexEntryTemplateElement}
     *
     *@param outlineLevel  The mandatory attribute {@attributeName  text:outline-level}" 
     *@param styleName  The mandatory attribute {@attributeName  text:style-name}" 
     *
     */
    public void init(OdfOutlineLevelType outlineLevel, OdfStyleNameRef styleName)
    {
        setOutlineLevel( outlineLevel );
        setStyleName( styleName );
    }

    /**
     * Get value of attribute {@attributeName text:outline-level}.
     *
     *@return return the attribute which type is OdfOutlineLevelType
     */
    public OdfOutlineLevelType getOutlineLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ) );
        return OdfOutlineLevelType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:outline-level}.
     *
     *@param  outlineLevel    the attribute's type is OdfOutlineLevelType
     */ 
     public void setOutlineLevel( OdfOutlineLevelType outlineLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ), outlineLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
    * Create child element {@odfLink text:index-entry-chapter}.
    *
    *@return   return  the element {@odfLink text:index-entry-chapter}
    */
    public OdfIndexEntryChapterElement createIndexEntryChapterElement()
    {
        OdfIndexEntryChapterElement  nIndexEntryChapter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexEntryChapterElement.class);
        this.appendChild( nIndexEntryChapter);
        return  nIndexEntryChapter;
    }                   
               
    /**
    * Create child element {@odfLink text:index-entry-page-number}.
    *
    *@return   return  the element {@odfLink text:index-entry-page-number}
    */
    public OdfIndexEntryPageNumberElement createIndexEntryPageNumberElement()
    {
        OdfIndexEntryPageNumberElement  nIndexEntryPageNumber = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexEntryPageNumberElement.class);
        this.appendChild( nIndexEntryPageNumber);
        return  nIndexEntryPageNumber;
    }                   
               
    /**
    * Create child element {@odfLink text:index-entry-text}.
    *
    *@return   return  the element {@odfLink text:index-entry-text}
    */
    public OdfIndexEntryTextElement createIndexEntryTextElement()
    {
        OdfIndexEntryTextElement  nIndexEntryText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexEntryTextElement.class);
        this.appendChild( nIndexEntryText);
        return  nIndexEntryText;
    }                   
               
    /**
    * Create child element {@odfLink text:index-entry-span}.
    *
    *@return   return  the element {@odfLink text:index-entry-span}
    */
    public OdfIndexEntrySpanElement createIndexEntrySpanElement()
    {
        OdfIndexEntrySpanElement  nIndexEntrySpan = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexEntrySpanElement.class);
        this.appendChild( nIndexEntrySpan);
        return  nIndexEntrySpan;
    }                   
               
    /**
    * Create child element {@odfLink text:index-entry-tab-stop}.
    *
    *@param type   the attribute's type is OdfIndexTabStopType, see {@attributeName  style:index-tab-stop} at specification
    *@return   return  the element {@odfLink text:index-entry-tab-stop}
    */
    public OdfIndexEntryTabStopElement createIndexEntryTabStopElement(OdfIndexTabStopType   type)
    {
        OdfIndexEntryTabStopElement  nIndexEntryTabStop = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexEntryTabStopElement.class);
        nIndexEntryTabStop.setType( type);
        this.appendChild( nIndexEntryTabStop);
        return  nIndexEntryTabStop;      
    }
    
    /**
    * Create child element {@odfLink text:index-entry-tab-stop}.
    *
    *@param type   the attribute's type is OdfIndexTabStopType, see {@attributeName  style:index-tab-stop} at specification
    *@param position  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink text:index-entry-tab-stop}
    */
    public OdfIndexEntryTabStopElement createIndexEntryTabStopElement(OdfIndexTabStopType   type, org.odftoolkit.odfdom.dom.type.OdfLength   position)
    {
        OdfIndexEntryTabStopElement  nIndexEntryTabStop = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexEntryTabStopElement.class);
        nIndexEntryTabStop.setType( type);
        nIndexEntryTabStop.setPosition( position);
        this.appendChild( nIndexEntryTabStop);
        return  nIndexEntryTabStop;      
    }
    
}
