/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

import org.odftoolkit.odfdom.dom.type.table.OdfSheetObjectType;
import org.odftoolkit.odfdom.dom.type.table.OdfSheetObjectType;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:tracked-changes}.
 *
 */
public abstract class OdfTrackedChangesElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "tracked-changes" );

    /**
     * Create the instance of OdfTrackedChangesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTrackedChangesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:tracked-changes}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:track-changes}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getTrackChanges()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "track-changes" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:track-changes}.
     *
     *@param  isTrackChanges    the attribute's type is OdfBoolean
     */ 
     public void setTrackChanges( OdfBoolean isTrackChanges )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "track-changes" ), isTrackChanges.toString() );
    }

    /**
    * Create child element {@odfLink table:cell-content-change}.
    *
    *@param id String   
    *@return   return  the element {@odfLink table:cell-content-change}
    */
    public OdfCellContentChangeElement createCellContentChangeElement(String   id)
    {
        OdfCellContentChangeElement  nCellContentChange = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCellContentChangeElement.class);
        nCellContentChange.setId( id);
        this.appendChild( nCellContentChange);
        return  nCellContentChange;      
    }
    
    /**
    * Create child element {@odfLink table:insertion}.
    *
    *@param type     the attribute's type is OdfSheetObjectType, see {@attributeName  table:sheet-object} at specification
    *@param position Integer   
    *@param id String   
    *@return   return  the element {@odfLink table:insertion}
    */
    public OdfInsertionElement createInsertionElement(OdfSheetObjectType   type, Integer   position, String   id)
    {
        OdfInsertionElement  nInsertion = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfInsertionElement.class);
        nInsertion.setType( type);
        nInsertion.setPosition( position);
        nInsertion.setId( id);
        this.appendChild( nInsertion);
        return  nInsertion;      
    }
    
    /**
    * Create child element {@odfLink table:deletion}.
    *
    *@param type     the attribute's type is OdfSheetObjectType, see {@attributeName  table:sheet-object} at specification
    *@param position Integer   
    *@param id String   
    *@return   return  the element {@odfLink table:deletion}
    */
    public OdfDeletionElement createDeletionElement(OdfSheetObjectType   type, Integer   position, String   id)
    {
        OdfDeletionElement  nDeletion = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDeletionElement.class);
        nDeletion.setType( type);
        nDeletion.setPosition( position);
        nDeletion.setId( id);
        this.appendChild( nDeletion);
        return  nDeletion;      
    }
    
    /**
    * Create child element {@odfLink table:movement}.
    *
    *@param id String   
    *@return   return  the element {@odfLink table:movement}
    */
    public OdfMovementElement createMovementElement(String   id)
    {
        OdfMovementElement  nMovement = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMovementElement.class);
        nMovement.setId( id);
        this.appendChild( nMovement);
        return  nMovement;      
    }
    
}
