/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:target-range-address}.
 *
 */
public abstract class OdfTargetRangeAddressElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "target-range-address" );

    /**
     * Create the instance of OdfTargetRangeAddressElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTargetRangeAddressElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:target-range-address}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfTargetRangeAddressElement}
     *
     *@param column  The mandatory attribute {@attributeName  table:column}" 
     *@param row  The mandatory attribute {@attributeName  table:row}" 
     *@param table  The mandatory attribute {@attributeName  table:table}" 
     *@param startColumn  The mandatory attribute {@attributeName  table:start-column}" 
     *@param startRow  The mandatory attribute {@attributeName  table:start-row}" 
     *@param startTable  The mandatory attribute {@attributeName  table:start-table}" 
     *@param endColumn  The mandatory attribute {@attributeName  table:end-column}" 
     *@param endRow  The mandatory attribute {@attributeName  table:end-row}" 
     *@param endTable  The mandatory attribute {@attributeName  table:end-table}" 
     *
     */
    public void init(Integer column, Integer row, Integer table, Integer startColumn, Integer startRow, Integer startTable, Integer endColumn, Integer endRow, Integer endTable)
    {
        setColumn( column );
        setRow( row );
        setTable( table );
        setStartColumn( startColumn );
        setStartRow( startRow );
        setStartTable( startTable );
        setEndColumn( endColumn );
        setEndRow( endRow );
        setEndTable( endTable );
    }

    /**
     * Get value of attribute {@attributeName table:column}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getColumn()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "column" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:column}.
     *
     *@param  column    the attribute's type is Integer
     */ 
     public void setColumn( Integer column )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "column" ), column.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:row}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getRow()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "row" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:row}.
     *
     *@param  row    the attribute's type is Integer
     */ 
     public void setRow( Integer row )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "row" ), row.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:table}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getTable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:table}.
     *
     *@param  table    the attribute's type is Integer
     */ 
     public void setTable( Integer table )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table" ), table.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:start-column}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getStartColumn()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start-column" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:start-column}.
     *
     *@param  startColumn    the attribute's type is Integer
     */ 
     public void setStartColumn( Integer startColumn )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start-column" ), startColumn.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:start-row}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getStartRow()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start-row" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:start-row}.
     *
     *@param  startRow    the attribute's type is Integer
     */ 
     public void setStartRow( Integer startRow )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start-row" ), startRow.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:start-table}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getStartTable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start-table" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:start-table}.
     *
     *@param  startTable    the attribute's type is Integer
     */ 
     public void setStartTable( Integer startTable )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start-table" ), startTable.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end-column}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getEndColumn()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-column" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-column}.
     *
     *@param  endColumn    the attribute's type is Integer
     */ 
     public void setEndColumn( Integer endColumn )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-column" ), endColumn.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end-row}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getEndRow()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-row" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-row}.
     *
     *@param  endRow    the attribute's type is Integer
     */ 
     public void setEndRow( Integer endRow )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-row" ), endRow.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end-table}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getEndTable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-table" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-table}.
     *
     *@param  endTable    the attribute's type is Integer
     */ 
     public void setEndTable( Integer endTable )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-table" ), endTable.toString() );
    }

}
