/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfRowOrColumnType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:table-template}.
 *
 */
public abstract class OdfTableTemplateElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "table-template" );

    /**
     * Create the instance of OdfTableTemplateElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableTemplateElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:table-template}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfTableTemplateElement}
     *
     *@param name  The mandatory attribute {@attributeName  table:name}" 
     *@param firstRowStartColumn  The mandatory attribute {@attributeName  table:first-row-start-column}" 
     *@param firstRowEndColumn  The mandatory attribute {@attributeName  table:first-row-end-column}" 
     *@param lastRowStartColumn  The mandatory attribute {@attributeName  table:last-row-start-column}" 
     *@param lastRowEndColumn  The mandatory attribute {@attributeName  table:last-row-end-column}" 
     *
     */
    public void init(String name, OdfRowOrColumnType firstRowStartColumn, OdfRowOrColumnType firstRowEndColumn, OdfRowOrColumnType lastRowStartColumn, OdfRowOrColumnType lastRowEndColumn)
    {
        setName( name );
        setFirstRowStartColumn( firstRowStartColumn );
        setFirstRowEndColumn( firstRowEndColumn );
        setLastRowStartColumn( lastRowStartColumn );
        setLastRowEndColumn( lastRowEndColumn );
    }

    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:first-row-start-column}.
     *
     *@return return the attribute which type is OdfRowOrColumnType
     */
    public OdfRowOrColumnType getFirstRowStartColumn()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "first-row-start-column" ) );
        return OdfRowOrColumnType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:first-row-start-column}.
     *
     *@param  firstRowStartColumn    the attribute's type is OdfRowOrColumnType
     */ 
     public void setFirstRowStartColumn( OdfRowOrColumnType firstRowStartColumn )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "first-row-start-column" ), firstRowStartColumn.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:first-row-end-column}.
     *
     *@return return the attribute which type is OdfRowOrColumnType
     */
    public OdfRowOrColumnType getFirstRowEndColumn()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "first-row-end-column" ) );
        return OdfRowOrColumnType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:first-row-end-column}.
     *
     *@param  firstRowEndColumn    the attribute's type is OdfRowOrColumnType
     */ 
     public void setFirstRowEndColumn( OdfRowOrColumnType firstRowEndColumn )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "first-row-end-column" ), firstRowEndColumn.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:last-row-start-column}.
     *
     *@return return the attribute which type is OdfRowOrColumnType
     */
    public OdfRowOrColumnType getLastRowStartColumn()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "last-row-start-column" ) );
        return OdfRowOrColumnType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:last-row-start-column}.
     *
     *@param  lastRowStartColumn    the attribute's type is OdfRowOrColumnType
     */ 
     public void setLastRowStartColumn( OdfRowOrColumnType lastRowStartColumn )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "last-row-start-column" ), lastRowStartColumn.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:last-row-end-column}.
     *
     *@return return the attribute which type is OdfRowOrColumnType
     */
    public OdfRowOrColumnType getLastRowEndColumn()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "last-row-end-column" ) );
        return OdfRowOrColumnType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:last-row-end-column}.
     *
     *@param  lastRowEndColumn    the attribute's type is OdfRowOrColumnType
     */ 
     public void setLastRowEndColumn( OdfRowOrColumnType lastRowEndColumn )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "last-row-end-column" ), lastRowEndColumn.toString() );
    }

    /**
    * Create child element {@odfLink table:first-row}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:first-row}
    */
    public OdfFirstRowElement createFirstRowElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfFirstRowElement  nFirstRow = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFirstRowElement.class);
        nFirstRow.setStyleName( styleName);
        this.appendChild( nFirstRow);
        return  nFirstRow;      
    }
    
    /**
    * Create child element {@odfLink table:last-row}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:last-row}
    */
    public OdfLastRowElement createLastRowElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfLastRowElement  nLastRow = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLastRowElement.class);
        nLastRow.setStyleName( styleName);
        this.appendChild( nLastRow);
        return  nLastRow;      
    }
    
    /**
    * Create child element {@odfLink table:first-column}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:first-column}
    */
    public OdfFirstColumnElement createFirstColumnElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfFirstColumnElement  nFirstColumn = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFirstColumnElement.class);
        nFirstColumn.setStyleName( styleName);
        this.appendChild( nFirstColumn);
        return  nFirstColumn;      
    }
    
    /**
    * Create child element {@odfLink table:last-column}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:last-column}
    */
    public OdfLastColumnElement createLastColumnElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfLastColumnElement  nLastColumn = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLastColumnElement.class);
        nLastColumn.setStyleName( styleName);
        this.appendChild( nLastColumn);
        return  nLastColumn;      
    }
    
    /**
    * Create child element {@odfLink table:body}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:body}
    */
    public OdfBodyElement createBodyElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfBodyElement  nBody = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBodyElement.class);
        nBody.setStyleName( styleName);
        this.appendChild( nBody);
        return  nBody;      
    }
    
    /**
    * Create child element {@odfLink table:even-rows}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:even-rows}
    */
    public OdfEvenRowsElement createEvenRowsElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfEvenRowsElement  nEvenRows = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEvenRowsElement.class);
        nEvenRows.setStyleName( styleName);
        this.appendChild( nEvenRows);
        return  nEvenRows;      
    }
    
    /**
    * Create child element {@odfLink table:odd-rows}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:odd-rows}
    */
    public OdfOddRowsElement createOddRowsElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfOddRowsElement  nOddRows = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOddRowsElement.class);
        nOddRows.setStyleName( styleName);
        this.appendChild( nOddRows);
        return  nOddRows;      
    }
    
    /**
    * Create child element {@odfLink table:even-columns}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:even-columns}
    */
    public OdfEvenColumnsElement createEvenColumnsElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfEvenColumnsElement  nEvenColumns = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEvenColumnsElement.class);
        nEvenColumns.setStyleName( styleName);
        this.appendChild( nEvenColumns);
        return  nEvenColumns;      
    }
    
    /**
    * Create child element {@odfLink table:odd-columns}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:odd-columns}
    */
    public OdfOddColumnsElement createOddColumnsElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfOddColumnsElement  nOddColumns = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOddColumnsElement.class);
        nOddColumns.setStyleName( styleName);
        this.appendChild( nOddColumns);
        return  nOddColumns;      
    }
    
    /**
    * Create child element {@odfLink table:background}.
    *
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink table:background}
    */
    public OdfBackgroundElement createBackgroundElement(org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfBackgroundElement  nBackground = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBackgroundElement.class);
        nBackground.setStyleName( styleName);
        this.appendChild( nBackground);
        return  nBackground;      
    }
    
}
