/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.table.OdfVisibilityType;
import org.odftoolkit.odfdom.dom.type.OdfId;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:table-row}.
 *
 */
public abstract class OdfTableRowElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "table-row" );

    /**
     * Create the instance of OdfTableRowElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableRowElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.TableRow, OdfName.get( OdfNamespace.TABLE, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:table-row}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:number-rows-repeated}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getNumberRowsRepeated()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "number-rows-repeated" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1";
        }

        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:number-rows-repeated}.
     *
     *@param  numberRowsRepeated    the attribute's type is OdfPositiveInteger
     */ 
     public void setNumberRowsRepeated( OdfPositiveInteger numberRowsRepeated )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "number-rows-repeated" ), numberRowsRepeated.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:default-cell-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDefaultCellStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "default-cell-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:default-cell-style-name}.
     *
     *@param  defaultCellStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDefaultCellStyleName( OdfStyleNameRef defaultCellStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "default-cell-style-name" ), defaultCellStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:visibility}.
     *
     *@return return the attribute which type is OdfVisibilityType
     */
    public OdfVisibilityType getVisibility()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "visibility" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "visible";
        }

        return OdfVisibilityType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:visibility}.
     *
     *@param  visibility    the attribute's type is OdfVisibilityType
     */ 
     public void setVisibility( OdfVisibilityType visibility )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "visibility" ), visibility.toString() );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink table:table-cell}.
    *
    *@return   return  the element {@odfLink table:table-cell}
    */
    public OdfTableCellElement createTableCellElement()
    {
        OdfTableCellElement  nTableCell = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableCellElement.class);
        this.appendChild( nTableCell);
        return  nTableCell;
    }                   
               
    /**
    * Create child element {@odfLink table:covered-table-cell}.
    *
    *@return   return  the element {@odfLink table:covered-table-cell}
    */
    public OdfCoveredTableCellElement createCoveredTableCellElement()
    {
        OdfCoveredTableCellElement  nCoveredTableCell = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCoveredTableCellElement.class);
        this.appendChild( nCoveredTableCell);
        return  nCoveredTableCell;
    }                   
               
}
