/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList;
import org.odftoolkit.odfdom.dom.type.OdfId;

import java.net.URI;
import org.odftoolkit.odfdom.dom.element.office.OdfDdeSourceElement;
import org.odftoolkit.odfdom.dom.element.form.OdfFormElement;
import org.odftoolkit.odfdom.dom.element.xforms.OdfModelElement;
import org.odftoolkit.odfdom.dom.element.text.OdfSoftPageBreakElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:table}.
 *
 */
public abstract class OdfTableElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "table" );

    /**
     * Create the instance of OdfTableElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Table, OdfName.get( OdfNamespace.TABLE, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:table}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:template-name}.
     *
     *@return return the attribute which type is String
     */
    public String getTemplateName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "template-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:template-name}.
     *
     *@param  templateName    the attribute's type is String
     */ 
     public void setTemplateName( String templateName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "template-name" ), templateName );
    }

    /**
     * Get value of attribute {@attributeName table:use-first-row-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseFirstRowStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-first-row-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-first-row-styles}.
     *
     *@param  isUseFirstRowStyles    the attribute's type is OdfBoolean
     */ 
     public void setUseFirstRowStyles( OdfBoolean isUseFirstRowStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-first-row-styles" ), isUseFirstRowStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:use-last-row-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseLastRowStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-last-row-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-last-row-styles}.
     *
     *@param  isUseLastRowStyles    the attribute's type is OdfBoolean
     */ 
     public void setUseLastRowStyles( OdfBoolean isUseLastRowStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-last-row-styles" ), isUseLastRowStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:use-first-column-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseFirstColumnStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-first-column-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-first-column-styles}.
     *
     *@param  isUseFirstColumnStyles    the attribute's type is OdfBoolean
     */ 
     public void setUseFirstColumnStyles( OdfBoolean isUseFirstColumnStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-first-column-styles" ), isUseFirstColumnStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:use-last-column-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseLastColumnStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-last-column-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-last-column-styles}.
     *
     *@param  isUseLastColumnStyles    the attribute's type is OdfBoolean
     */ 
     public void setUseLastColumnStyles( OdfBoolean isUseLastColumnStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-last-column-styles" ), isUseLastColumnStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:use-banding-rows-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseBandingRowsStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-banding-rows-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-banding-rows-styles}.
     *
     *@param  isUseBandingRowsStyles    the attribute's type is OdfBoolean
     */ 
     public void setUseBandingRowsStyles( OdfBoolean isUseBandingRowsStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-banding-rows-styles" ), isUseBandingRowsStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:use-banding-columns-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseBandingColumnsStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-banding-columns-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-banding-columns-styles}.
     *
     *@param  isUseBandingColumnsStyles    the attribute's type is OdfBoolean
     */ 
     public void setUseBandingColumnsStyles( OdfBoolean isUseBandingColumnsStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-banding-columns-styles" ), isUseBandingColumnsStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:protected}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getProtected()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protected" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:protected}.
     *
     *@param  isProtected    the attribute's type is OdfBoolean
     */ 
     public void setProtected( OdfBoolean isProtected )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protected" ), isProtected.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:protection-key}.
     *
     *@return return the attribute which type is String
     */
    public String getProtectionKey()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protection-key" ) );
    }

    /**
     * Set value of attribute {@attributeName table:protection-key}.
     *
     *@param  protectionKey    the attribute's type is String
     */ 
     public void setProtectionKey( String protectionKey )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protection-key" ), protectionKey );
    }

    /**
     * Get value of attribute {@attributeName table:protection-key-digest-algorithm}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getProtectionKeyDigestAlgorithm()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protection-key-digest-algorithm" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "http://www.w3.org/2000/09/xmldsig#sha1";
        }

        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:protection-key-digest-algorithm}.
     *
     *@param  protectionKeyDigestAlgorithm    the attribute's type is OdfAnyURI
     */ 
     public void setProtectionKeyDigestAlgorithm( OdfAnyURI protectionKeyDigestAlgorithm )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protection-key-digest-algorithm" ), protectionKeyDigestAlgorithm.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:print}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getPrint()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "print" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:print}.
     *
     *@param  isPrint    the attribute's type is OdfBoolean
     */ 
     public void setPrint( OdfBoolean isPrint )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "print" ), isPrint.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:print-ranges}.
     *
     *@return return the attribute which type is OdfCellRangeAddressList
     */
    public OdfCellRangeAddressList getPrintRanges()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "print-ranges" ) );
        return OdfCellRangeAddressList.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:print-ranges}.
     *
     *@param  printRanges    the attribute's type is OdfCellRangeAddressList
     */ 
     public void setPrintRanges( OdfCellRangeAddressList printRanges )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "print-ranges" ), printRanges.toString() );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:is-sub-table}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsSubTable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "is-sub-table" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:is-sub-table}.
     *
     *@param  isIsSubTable    the attribute's type is OdfBoolean
     */ 
     public void setIsSubTable( OdfBoolean isIsSubTable )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "is-sub-table" ), isIsSubTable.toString() );
    }

    /**
    * Create child element {@odfLink table:title}.
    *
    *@return   return  the element {@odfLink table:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink table:desc}.
    *
    *@return   return  the element {@odfLink table:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
    /**
    * Create child element {@odfLink table:table-source}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink table:table-source}
    */
    public OdfTableSourceElement createTableSourceElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfTableSourceElement  nTableSource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableSourceElement.class);
        nTableSource.setHref( href);
        this.appendChild( nTableSource);
        return  nTableSource;      
    }
    
    /**
    * Create child element {@odfLink office:dde-source}.
    *
    *@param ddeApplication String   
    *@param ddeTopic String   
    *@param ddeItem String   
    *@return   return  the element {@odfLink office:dde-source}
    */
    public OdfDdeSourceElement createDdeSourceElement(String   ddeApplication, String   ddeTopic, String   ddeItem)
    {
        OdfDdeSourceElement  nDdeSource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDdeSourceElement.class);
        nDdeSource.setDdeApplication( ddeApplication);
        nDdeSource.setDdeTopic( ddeTopic);
        nDdeSource.setDdeItem( ddeItem);
        this.appendChild( nDdeSource);
        return  nDdeSource;      
    }
    
    /**
    * Create child element {@odfLink table:scenario}.
    *
    *@param scenarioRanges  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList
    *@param isActive  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@return   return  the element {@odfLink table:scenario}
    */
    public OdfScenarioElement createScenarioElement(org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList   scenarioRanges, org.odftoolkit.odfdom.dom.type.OdfBoolean   isActive)
    {
        OdfScenarioElement  nScenario = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfScenarioElement.class);
        nScenario.setScenarioRanges( scenarioRanges);
        nScenario.setIsActive( isActive);
        this.appendChild( nScenario);
        return  nScenario;      
    }
    
    /**
    * Create child element {@odfLink form:form}.
    *
    *@return   return  the element {@odfLink form:form}
    */
    public OdfFormElement createFormElement()
    {
        OdfFormElement  nForm = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormElement.class);
        this.appendChild( nForm);
        return  nForm;
    }                   
               
    /**
    * Create child element {@odfLink xforms:model}.
    *
    *@return   return  the element {@odfLink xforms:model}
    */
    public OdfModelElement createModelElement()
    {
        OdfModelElement  nModel = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfModelElement.class);
        this.appendChild( nModel);
        return  nModel;
    }                   
               
    /**
    * Create child element {@odfLink table:shapes}.
    *
    *@return   return  the element {@odfLink table:shapes}
    */
    public OdfShapesElement createShapesElement()
    {
        OdfShapesElement  nShapes = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfShapesElement.class);
        this.appendChild( nShapes);
        return  nShapes;
    }                   
               
    /**
    * Create child element {@odfLink table:table-column-group}.
    *
    *@return   return  the element {@odfLink table:table-column-group}
    */
    public OdfTableColumnGroupElement createTableColumnGroupElement()
    {
        OdfTableColumnGroupElement  nTableColumnGroup = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableColumnGroupElement.class);
        this.appendChild( nTableColumnGroup);
        return  nTableColumnGroup;
    }                   
               
    /**
    * Create child element {@odfLink table:table-columns}.
    *
    *@return   return  the element {@odfLink table:table-columns}
    */
    public OdfTableColumnsElement createTableColumnsElement()
    {
        OdfTableColumnsElement  nTableColumns = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableColumnsElement.class);
        this.appendChild( nTableColumns);
        return  nTableColumns;
    }                   
               
    /**
    * Create child element {@odfLink table:table-column}.
    *
    *@return   return  the element {@odfLink table:table-column}
    */
    public OdfTableColumnElement createTableColumnElement()
    {
        OdfTableColumnElement  nTableColumn = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableColumnElement.class);
        this.appendChild( nTableColumn);
        return  nTableColumn;
    }                   
               
    /**
    * Create child element {@odfLink table:table-header-columns}.
    *
    *@return   return  the element {@odfLink table:table-header-columns}
    */
    public OdfTableHeaderColumnsElement createTableHeaderColumnsElement()
    {
        OdfTableHeaderColumnsElement  nTableHeaderColumns = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableHeaderColumnsElement.class);
        this.appendChild( nTableHeaderColumns);
        return  nTableHeaderColumns;
    }                   
               
    /**
    * Create child element {@odfLink table:table-row-group}.
    *
    *@return   return  the element {@odfLink table:table-row-group}
    */
    public OdfTableRowGroupElement createTableRowGroupElement()
    {
        OdfTableRowGroupElement  nTableRowGroup = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableRowGroupElement.class);
        this.appendChild( nTableRowGroup);
        return  nTableRowGroup;
    }                   
               
    /**
    * Create child element {@odfLink table:table-rows}.
    *
    *@return   return  the element {@odfLink table:table-rows}
    */
    public OdfTableRowsElement createTableRowsElement()
    {
        OdfTableRowsElement  nTableRows = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableRowsElement.class);
        this.appendChild( nTableRows);
        return  nTableRows;
    }                   
               
    /**
    * Create child element {@odfLink text:soft-page-break}.
    *
    *@return   return  the element {@odfLink text:soft-page-break}
    */
    public OdfSoftPageBreakElement createSoftPageBreakElement()
    {
        OdfSoftPageBreakElement  nSoftPageBreak = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoftPageBreakElement.class);
        this.appendChild( nSoftPageBreak);
        return  nSoftPageBreak;
    }                   
               
    /**
    * Create child element {@odfLink table:table-row}.
    *
    *@return   return  the element {@odfLink table:table-row}
    */
    public OdfTableRowElement createTableRowElement()
    {
        OdfTableRowElement  nTableRow = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableRowElement.class);
        this.appendChild( nTableRow);
        return  nTableRow;
    }                   
               
    /**
    * Create child element {@odfLink table:table-header-rows}.
    *
    *@return   return  the element {@odfLink table:table-header-rows}
    */
    public OdfTableHeaderRowsElement createTableHeaderRowsElement()
    {
        OdfTableHeaderRowsElement  nTableHeaderRows = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableHeaderRowsElement.class);
        this.appendChild( nTableHeaderRows);
        return  nTableHeaderRows;
    }                   
               
}
