/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    
package org.odftoolkit.odfdom.dom.element.table;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.odftoolkit.odfdom.dom.type.OdfDate;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfId;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;


/**
 * DOM implementation of OpenDocument base element 
 */
public abstract class OdfTableCellElementBase extends OdfStylableElement
{
    /**
     * Create the instance of OdfTableCellElementBase 
     *
     *@param  aOwnerDoc      The type is OdfFileDom
     *@param  aElement_name   The type is OdfName
     *@param  aStyleFamily    The type is OdfStyleFamily
     *@param  aStyleAttrName  The type is OdfName  
     */
    public OdfTableCellElementBase( OdfFileDom aOwnerDoc ,OdfName aElementName ,OdfStyleFamily aStyleFamily ,OdfName aStyleAttrName )
    {
        super( aOwnerDoc, aElementName, aStyleFamily, aStyleAttrName );
    }
    /**
     * Initialization of the mandatory attributes of {@link  OdfTableCellElementBase}
     *
     
    *
     */
    public void init()
    {
    }
      
    /**
     * Get value of attribute {@attributeName table:number-columns-repeated}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getNumberColumnsRepeated()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "number-columns-repeated" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1";
        }

        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:number-columns-repeated}.
     *
     *@param  numberColumnsRepeated    the attribute's type is OdfPositiveInteger
     */ 
     public void setNumberColumnsRepeated( OdfPositiveInteger numberColumnsRepeated )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "number-columns-repeated" ), numberColumnsRepeated.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:content-validation-name}.
     *
     *@return return the attribute which type is String
     */
    public String getContentValidationName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "content-validation-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:content-validation-name}.
     *
     *@param  contentValidationName    the attribute's type is String
     */ 
     public void setContentValidationName( String contentValidationName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "content-validation-name" ), contentValidationName );
    }

    /**
     * Get value of attribute {@attributeName table:formula}.
     *
     *@return return the attribute which type is String
     */
    public String getFormula()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "formula" ) );
    }

    /**
     * Set value of attribute {@attributeName table:formula}.
     *
     *@param  formula    the attribute's type is String
     */ 
     public void setFormula( String formula )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "formula" ), formula );
    }

    /**
     * Get value of attribute {@attributeName office:value-type}.
     *
     *@return return the attribute which type is OdfValueType
     */
    public OdfValueType getValueType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ) );
        return OdfValueType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value-type}.
     *
     *@param  valueType    the attribute's type is OdfValueType
     */ 
     public void setValueType( OdfValueType valueType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ), valueType.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:value}.
     *
     *@return return the attribute which type is Double
     */
    public Double getValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value}.
     *
     *@param  value    the attribute's type is Double
     */ 
     public void setValue( Double value )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value" ), value.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:currency}.
     *
     *@return return the attribute which type is String
     */
    public String getCurrency()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "currency" ) );
    }

    /**
     * Set value of attribute {@attributeName office:currency}.
     *
     *@param  currency    the attribute's type is String
     */ 
     public void setCurrency( String currency )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "currency" ), currency );
    }

    /**
     * Get value of attribute {@attributeName office:date-value}.
     *
     *@return return the attribute which type is OdfDate
     */
    public OdfDate getDateValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "date-value" ) );
        return OdfDate.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:date-value}.
     *
     *@param  dateValue    the attribute's type is OdfDate
     */ 
     public void setDateValue( OdfDate dateValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "date-value" ), dateValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:time-value}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getTimeValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "time-value" ) );
        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:time-value}.
     *
     *@param  timeValue    the attribute's type is OdfDuration
     */ 
     public void setTimeValue( OdfDuration timeValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "time-value" ), timeValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:boolean-value}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getBooleanValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "boolean-value" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:boolean-value}.
     *
     *@param  isBooleanValue    the attribute's type is OdfBoolean
     */ 
     public void setBooleanValue( OdfBoolean isBooleanValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "boolean-value" ), isBooleanValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:string-value}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "string-value" ) );
    }

    /**
     * Set value of attribute {@attributeName office:string-value}.
     *
     *@param  stringValue    the attribute's type is String
     */ 
     public void setStringValue( String stringValue )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "string-value" ), stringValue );
    }

    /**
     * Get value of attribute {@attributeName table:protect}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getProtect()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protect" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:protect}.
     *
     *@param  isProtect    the attribute's type is OdfBoolean
     */ 
     public void setProtect( OdfBoolean isProtect )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protect" ), isProtect.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:protected}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getProtected()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protected" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:protected}.
     *
     *@param  isProtected    the attribute's type is OdfBoolean
     */ 
     public void setProtected( OdfBoolean isProtected )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protected" ), isProtected.toString() );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName xhtml:about}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getAbout()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "about" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xhtml:about}.
     *
     *@param  about    the attribute's type is OdfAnyURI
     */ 
     public void setAbout( OdfAnyURI about )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "about" ), about.toString() );
    }

    /**
     * Get value of attribute {@attributeName xhtml:property}.
     *
     *@return return the attribute which type is String
     */
    public String getProperty()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "property" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:property}.
     *
     *@param  property    the attribute's type is String
     */ 
     public void setProperty( String property )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "property" ), property );
    }

    /**
     * Get value of attribute {@attributeName xhtml:datatype}.
     *
     *@return return the attribute which type is String
     */
    public String getDatatype()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "datatype" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:datatype}.
     *
     *@param  datatype    the attribute's type is String
     */ 
     public void setDatatype( String datatype )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "datatype" ), datatype );
    }

    /**
     * Get value of attribute {@attributeName xhtml:content}.
     *
     *@return return the attribute which type is String
     */
    public String getContent()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "content" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:content}.
     *
     *@param  content    the attribute's type is String
     */ 
     public void setContent( String content )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "content" ), content );
    }

}
      