/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:subtotal-rules}.
 *
 */
public abstract class OdfSubtotalRulesElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "subtotal-rules" );

    /**
     * Create the instance of OdfSubtotalRulesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSubtotalRulesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:subtotal-rules}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:bind-styles-to-content}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getBindStylesToContent()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "bind-styles-to-content" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:bind-styles-to-content}.
     *
     *@param  isBindStylesToContent    the attribute's type is OdfBoolean
     */ 
     public void setBindStylesToContent( OdfBoolean isBindStylesToContent )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "bind-styles-to-content" ), isBindStylesToContent.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:case-sensitive}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCaseSensitive()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "case-sensitive" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:case-sensitive}.
     *
     *@param  isCaseSensitive    the attribute's type is OdfBoolean
     */ 
     public void setCaseSensitive( OdfBoolean isCaseSensitive )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "case-sensitive" ), isCaseSensitive.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:page-breaks-on-group-change}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getPageBreaksOnGroupChange()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "page-breaks-on-group-change" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:page-breaks-on-group-change}.
     *
     *@param  isPageBreaksOnGroupChange    the attribute's type is OdfBoolean
     */ 
     public void setPageBreaksOnGroupChange( OdfBoolean isPageBreaksOnGroupChange )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "page-breaks-on-group-change" ), isPageBreaksOnGroupChange.toString() );
    }

    /**
    * Create child element {@odfLink table:sort-groups}.
    *
    *@return   return  the element {@odfLink table:sort-groups}
    */
    public OdfSortGroupsElement createSortGroupsElement()
    {
        OdfSortGroupsElement  nSortGroups = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSortGroupsElement.class);
        this.appendChild( nSortGroups);
        return  nSortGroups;
    }                   
               
    /**
    * Create child element {@odfLink table:subtotal-rule}.
    *
    *@param groupByFieldNumber  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@return   return  the element {@odfLink table:subtotal-rule}
    */
    public OdfSubtotalRuleElement createSubtotalRuleElement(org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   groupByFieldNumber)
    {
        OdfSubtotalRuleElement  nSubtotalRule = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSubtotalRuleElement.class);
        nSubtotalRule.setGroupByFieldNumber( groupByFieldNumber);
        this.appendChild( nSubtotalRule);
        return  nSubtotalRule;      
    }
    
}
