/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:source-service}.
 *
 */
public abstract class OdfSourceServiceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "source-service" );

    /**
     * Create the instance of OdfSourceServiceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSourceServiceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:source-service}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfSourceServiceElement}
     *
     *@param name  The mandatory attribute {@attributeName  table:name}" 
     *@param sourceName  The mandatory attribute {@attributeName  table:source-name}" 
     *@param objectName  The mandatory attribute {@attributeName  table:object-name}" 
     *
     */
    public void init(String name, String sourceName, String objectName)
    {
        setName( name );
        setSourceName( sourceName );
        setObjectName( objectName );
    }

    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:source-name}.
     *
     *@return return the attribute which type is String
     */
    public String getSourceName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "source-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:source-name}.
     *
     *@param  sourceName    the attribute's type is String
     */ 
     public void setSourceName( String sourceName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "source-name" ), sourceName );
    }

    /**
     * Get value of attribute {@attributeName table:object-name}.
     *
     *@return return the attribute which type is String
     */
    public String getObjectName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "object-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:object-name}.
     *
     *@param  objectName    the attribute's type is String
     */ 
     public void setObjectName( String objectName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "object-name" ), objectName );
    }

    /**
     * Get value of attribute {@attributeName table:user-name}.
     *
     *@return return the attribute which type is String
     */
    public String getUserName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "user-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:user-name}.
     *
     *@param  userName    the attribute's type is String
     */ 
     public void setUserName( String userName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "user-name" ), userName );
    }

    /**
     * Get value of attribute {@attributeName table:password}.
     *
     *@return return the attribute which type is String
     */
    public String getPassword()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "password" ) );
    }

    /**
     * Set value of attribute {@attributeName table:password}.
     *
     *@param  password    the attribute's type is String
     */ 
     public void setPassword( String password )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "password" ), password );
    }

}
