/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:source-cell-range}.
 *
 */
public abstract class OdfSourceCellRangeElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "source-cell-range" );

    /**
     * Create the instance of OdfSourceCellRangeElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSourceCellRangeElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:source-cell-range}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfSourceCellRangeElement}
     *
     *@param cellRangeAddress  The mandatory attribute {@attributeName  table:cell-range-address}" 
     *
     */
    public void init(OdfCellRangeAddress cellRangeAddress)
    {
        setCellRangeAddress( cellRangeAddress );
    }

    /**
     * Get value of attribute {@attributeName table:cell-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getCellRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:cell-range-address}.
     *
     *@param  cellRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setCellRangeAddress( OdfCellRangeAddress cellRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-range-address" ), cellRangeAddress.toString() );
    }

    /**
    * Create child element {@odfLink table:filter}.
    *
    *@return   return  the element {@odfLink table:filter}
    */
    public OdfFilterElement createFilterElement()
    {
        OdfFilterElement  nFilter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterElement.class);
        this.appendChild( nFilter);
        return  nFilter;
    }                   
               
}
