/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;
import org.odftoolkit.odfdom.dom.type.table.OdfEmbeddedNumberBehaviorType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:sort}.
 *
 */
public abstract class OdfSortElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "sort" );

    /**
     * Create the instance of OdfSortElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSortElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:sort}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:bind-styles-to-content}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getBindStylesToContent()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "bind-styles-to-content" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:bind-styles-to-content}.
     *
     *@param  isBindStylesToContent    the attribute's type is OdfBoolean
     */ 
     public void setBindStylesToContent( OdfBoolean isBindStylesToContent )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "bind-styles-to-content" ), isBindStylesToContent.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:target-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getTargetRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:target-range-address}.
     *
     *@param  targetRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setTargetRangeAddress( OdfCellRangeAddress targetRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-range-address" ), targetRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:case-sensitive}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCaseSensitive()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "case-sensitive" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:case-sensitive}.
     *
     *@param  isCaseSensitive    the attribute's type is OdfBoolean
     */ 
     public void setCaseSensitive( OdfBoolean isCaseSensitive )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "case-sensitive" ), isCaseSensitive.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:language}.
     *
     *@return return the attribute which type is String
     */
    public String getLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "language" ) );
    }

    /**
     * Set value of attribute {@attributeName table:language}.
     *
     *@param  language    the attribute's type is String
     */ 
     public void setLanguage( String language )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "language" ), language );
    }

    /**
     * Get value of attribute {@attributeName table:country}.
     *
     *@return return the attribute which type is String
     */
    public String getCountry()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "country" ) );
    }

    /**
     * Set value of attribute {@attributeName table:country}.
     *
     *@param  country    the attribute's type is String
     */ 
     public void setCountry( String country )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "country" ), country );
    }

    /**
     * Get value of attribute {@attributeName table:script}.
     *
     *@return return the attribute which type is String
     */
    public String getScript()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "script" ) );
    }

    /**
     * Set value of attribute {@attributeName table:script}.
     *
     *@param  script    the attribute's type is String
     */ 
     public void setScript( String script )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "script" ), script );
    }

    /**
     * Get value of attribute {@attributeName table:rfc-language-tag}.
     *
     *@return return the attribute which type is String
     */
    public String getRfcLanguageTag()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "rfc-language-tag" ) );
    }

    /**
     * Set value of attribute {@attributeName table:rfc-language-tag}.
     *
     *@param  rfcLanguageTag    the attribute's type is String
     */ 
     public void setRfcLanguageTag( String rfcLanguageTag )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "rfc-language-tag" ), rfcLanguageTag );
    }

    /**
     * Get value of attribute {@attributeName table:algorithm}.
     *
     *@return return the attribute which type is String
     */
    public String getAlgorithm()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "algorithm" ) );
    }

    /**
     * Set value of attribute {@attributeName table:algorithm}.
     *
     *@param  algorithm    the attribute's type is String
     */ 
     public void setAlgorithm( String algorithm )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "algorithm" ), algorithm );
    }

    /**
     * Get value of attribute {@attributeName table:embedded-number-behavior}.
     *
     *@return return the attribute which type is OdfEmbeddedNumberBehaviorType
     */
    public OdfEmbeddedNumberBehaviorType getEmbeddedNumberBehavior()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "embedded-number-behavior" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "alpha-numeric";
        }

        return OdfEmbeddedNumberBehaviorType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:embedded-number-behavior}.
     *
     *@param  embeddedNumberBehavior    the attribute's type is OdfEmbeddedNumberBehaviorType
     */ 
     public void setEmbeddedNumberBehavior( OdfEmbeddedNumberBehaviorType embeddedNumberBehavior )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "embedded-number-behavior" ), embeddedNumberBehavior.toString() );
    }

    /**
    * Create child element {@odfLink table:sort-by}.
    *
    *@param fieldNumber  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@return   return  the element {@odfLink table:sort-by}
    */
    public OdfSortByElement createSortByElement(org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   fieldNumber)
    {
        OdfSortByElement  nSortBy = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSortByElement.class);
        nSortBy.setFieldNumber( fieldNumber);
        this.appendChild( nSortBy);
        return  nSortBy;      
    }
    
}
