/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.table.OdfOrderType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:sort-by}.
 *
 */
public abstract class OdfSortByElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "sort-by" );

    /**
     * Create the instance of OdfSortByElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSortByElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:sort-by}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfSortByElement}
     *
     *@param fieldNumber  The mandatory attribute {@attributeName  table:field-number}" 
     *
     */
    public void init(OdfNonNegativeInteger fieldNumber)
    {
        setFieldNumber( fieldNumber );
    }

    /**
     * Get value of attribute {@attributeName table:field-number}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getFieldNumber()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "field-number" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:field-number}.
     *
     *@param  fieldNumber    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setFieldNumber( OdfNonNegativeInteger fieldNumber )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "field-number" ), fieldNumber.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:data-type}.
     *
     *@return return the attribute which type is String
     */
    public String getDataType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "automatic";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:data-type}.
     *
     *@param  dataType    the attribute's type is String
     */ 
     public void setDataType( String dataType )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-type" ), dataType );
    }

    /**
     * Get value of attribute {@attributeName table:order}.
     *
     *@return return the attribute which type is OdfOrderType
     */
    public OdfOrderType getOrder()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "order" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "ascending";
        }

        return OdfOrderType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:order}.
     *
     *@param  order    the attribute's type is OdfOrderType
     */ 
     public void setOrder( OdfOrderType order )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "order" ), order.toString() );
    }

}
