/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:scenario}.
 *
 */
public abstract class OdfScenarioElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "scenario" );

    /**
     * Create the instance of OdfScenarioElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfScenarioElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:scenario}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfScenarioElement}
     *
     *@param scenarioRanges  The mandatory attribute {@attributeName  table:scenario-ranges}" 
     *@param isActive  The mandatory attribute {@attributeName  table:is-active}" 
     *
     */
    public void init(OdfCellRangeAddressList scenarioRanges, OdfBoolean isActive)
    {
        setScenarioRanges( scenarioRanges );
        setIsActive( isActive );
    }

    /**
     * Get value of attribute {@attributeName table:scenario-ranges}.
     *
     *@return return the attribute which type is OdfCellRangeAddressList
     */
    public OdfCellRangeAddressList getScenarioRanges()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "scenario-ranges" ) );
        return OdfCellRangeAddressList.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:scenario-ranges}.
     *
     *@param  scenarioRanges    the attribute's type is OdfCellRangeAddressList
     */ 
     public void setScenarioRanges( OdfCellRangeAddressList scenarioRanges )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "scenario-ranges" ), scenarioRanges.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:is-active}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsActive()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "is-active" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:is-active}.
     *
     *@param  isIsActive    the attribute's type is OdfBoolean
     */ 
     public void setIsActive( OdfBoolean isIsActive )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "is-active" ), isIsActive.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:display-border}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDisplayBorder()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-border" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:display-border}.
     *
     *@param  isDisplayBorder    the attribute's type is OdfBoolean
     */ 
     public void setDisplayBorder( OdfBoolean isDisplayBorder )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-border" ), isDisplayBorder.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:border-color}.
     *
     *@return return the attribute which type is String
     */
    public String getBorderColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "border-color" ) );
    }

    /**
     * Set value of attribute {@attributeName table:border-color}.
     *
     *@param  borderColor    the attribute's type is String
     */ 
     public void setBorderColor( String borderColor )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "border-color" ), borderColor );
    }

    /**
     * Get value of attribute {@attributeName table:copy-back}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCopyBack()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "copy-back" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:copy-back}.
     *
     *@param  isCopyBack    the attribute's type is OdfBoolean
     */ 
     public void setCopyBack( OdfBoolean isCopyBack )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "copy-back" ), isCopyBack.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:copy-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCopyStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "copy-styles" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:copy-styles}.
     *
     *@param  isCopyStyles    the attribute's type is OdfBoolean
     */ 
     public void setCopyStyles( OdfBoolean isCopyStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "copy-styles" ), isCopyStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:copy-formulas}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCopyFormulas()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "copy-formulas" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:copy-formulas}.
     *
     *@param  isCopyFormulas    the attribute's type is OdfBoolean
     */ 
     public void setCopyFormulas( OdfBoolean isCopyFormulas )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "copy-formulas" ), isCopyFormulas.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:comment}.
     *
     *@return return the attribute which type is String
     */
    public String getComment()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "comment" ) );
    }

    /**
     * Set value of attribute {@attributeName table:comment}.
     *
     *@param  comment    the attribute's type is String
     */ 
     public void setComment( String comment )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "comment" ), comment );
    }

    /**
     * Get value of attribute {@attributeName table:protected}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getProtected()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protected" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:protected}.
     *
     *@param  isProtected    the attribute's type is OdfBoolean
     */ 
     public void setProtected( OdfBoolean isProtected )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "protected" ), isProtected.toString() );
    }

}
