/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfNameType;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:operation}.
 *
 */
public abstract class OdfOperationElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "operation" );

    /**
     * Create the instance of OdfOperationElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfOperationElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:operation}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfOperationElement}
     *
     *@param name  The mandatory attribute {@attributeName  table:name}" 
     *@param index  The mandatory attribute {@attributeName  table:index}" 
     *
     */
    public void init(OdfNameType name, OdfNonNegativeInteger index)
    {
        setName( name );
        setIndex( index );
    }

    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is OdfNameType
     */
    public OdfNameType getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
        return OdfNameType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is OdfNameType
     */ 
     public void setName( OdfNameType name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:index}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getIndex()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "index" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:index}.
     *
     *@param  index    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setIndex( OdfNonNegativeInteger index )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "index" ), index.toString() );
    }

}
