/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfValueType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.odftoolkit.odfdom.dom.type.OdfDate;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:null-date}.
 *
 */
public abstract class OdfNullDateElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "null-date" );

    /**
     * Create the instance of OdfNullDateElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfNullDateElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:null-date}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:value-type}.
     *
     *@return return the attribute which type is OdfValueType
     */
    public OdfValueType getValueType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "value-type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "date";
        }

        return OdfValueType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:value-type}.
     *
     *@param  valueType    the attribute's type is OdfValueType
     */ 
     public void setValueType( OdfValueType valueType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "value-type" ), valueType.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:date-value}.
     *
     *@return return the attribute which type is OdfDate
     */
    public OdfDate getDateValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "date-value" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1899-12-30";
        }

        return OdfDate.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:date-value}.
     *
     *@param  dateValue    the attribute's type is OdfDate
     */ 
     public void setDateValue( OdfDate dateValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "date-value" ), dateValue.toString() );
    }

}
