/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellAddress;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:named-expression}.
 *
 */
public abstract class OdfNamedExpressionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "named-expression" );

    /**
     * Create the instance of OdfNamedExpressionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfNamedExpressionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:named-expression}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfNamedExpressionElement}
     *
     *@param name  The mandatory attribute {@attributeName  table:name}" 
     *@param expression  The mandatory attribute {@attributeName  table:expression}" 
     *
     */
    public void init(String name, String expression)
    {
        setName( name );
        setExpression( expression );
    }

    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:expression}.
     *
     *@return return the attribute which type is String
     */
    public String getExpression()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "expression" ) );
    }

    /**
     * Set value of attribute {@attributeName table:expression}.
     *
     *@param  expression    the attribute's type is String
     */ 
     public void setExpression( String expression )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "expression" ), expression );
    }

    /**
     * Get value of attribute {@attributeName table:base-cell-address}.
     *
     *@return return the attribute which type is OdfCellAddress
     */
    public OdfCellAddress getBaseCellAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "base-cell-address" ) );
        return OdfCellAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:base-cell-address}.
     *
     *@param  baseCellAddress    the attribute's type is OdfCellAddress
     */ 
     public void setBaseCellAddress( OdfCellAddress baseCellAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "base-cell-address" ), baseCellAddress.toString() );
    }

}
