/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:movement-cut-off}.
 *
 */
public abstract class OdfMovementCutOffElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "movement-cut-off" );

    /**
     * Create the instance of OdfMovementCutOffElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfMovementCutOffElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:movement-cut-off}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfMovementCutOffElement}
     *
     *@param position  The mandatory attribute {@attributeName  table:position}" 
     *@param startPosition  The mandatory attribute {@attributeName  table:start-position}" 
     *@param endPosition  The mandatory attribute {@attributeName  table:end-position}" 
     *
     */
    public void init(Integer position, Integer startPosition, Integer endPosition)
    {
        setPosition( position );
        setStartPosition( startPosition );
        setEndPosition( endPosition );
    }

    /**
     * Get value of attribute {@attributeName table:position}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "position" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:position}.
     *
     *@param  position    the attribute's type is Integer
     */ 
     public void setPosition( Integer position )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "position" ), position.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:start-position}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getStartPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start-position" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:start-position}.
     *
     *@param  startPosition    the attribute's type is Integer
     */ 
     public void setStartPosition( Integer startPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start-position" ), startPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end-position}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getEndPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-position" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-position}.
     *
     *@param  endPosition    the attribute's type is Integer
     */ 
     public void setEndPosition( Integer endPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-position" ), endPosition.toString() );
    }

}
