/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.type.table.OdfLabelOrientationType;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:label-ranges}.
 *
 */
public abstract class OdfLabelRangesElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "label-ranges" );

    /**
     * Create the instance of OdfLabelRangesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfLabelRangesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:label-ranges}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink table:label-range}.
    *
    *@param labelCellRangeAddress  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress
    *@param dataCellRangeAddress  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress
    *@param orientation     the attribute's type is OdfLabelOrientationType, see {@attributeName  table:label-orientation} at specification
    *@return   return  the element {@odfLink table:label-range}
    */
    public OdfLabelRangeElement createLabelRangeElement(org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress   labelCellRangeAddress, org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress   dataCellRangeAddress, OdfLabelOrientationType   orientation)
    {
        OdfLabelRangeElement  nLabelRange = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLabelRangeElement.class);
        nLabelRange.setLabelCellRangeAddress( labelCellRangeAddress);
        nLabelRange.setDataCellRangeAddress( dataCellRangeAddress);
        nLabelRange.setOrientation( orientation);
        this.appendChild( nLabelRange);
        return  nLabelRange;      
    }
    
}
