/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;
import org.odftoolkit.odfdom.dom.type.table.OdfLabelOrientationType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:label-range}.
 *
 */
public abstract class OdfLabelRangeElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "label-range" );

    /**
     * Create the instance of OdfLabelRangeElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfLabelRangeElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:label-range}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfLabelRangeElement}
     *
     *@param labelCellRangeAddress  The mandatory attribute {@attributeName  table:label-cell-range-address}" 
     *@param dataCellRangeAddress  The mandatory attribute {@attributeName  table:data-cell-range-address}" 
     *@param orientation  The mandatory attribute {@attributeName  table:orientation}" 
     *
     */
    public void init(OdfCellRangeAddress labelCellRangeAddress, OdfCellRangeAddress dataCellRangeAddress, OdfLabelOrientationType orientation)
    {
        setLabelCellRangeAddress( labelCellRangeAddress );
        setDataCellRangeAddress( dataCellRangeAddress );
        setOrientation( orientation );
    }

    /**
     * Get value of attribute {@attributeName table:label-cell-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getLabelCellRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "label-cell-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:label-cell-range-address}.
     *
     *@param  labelCellRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setLabelCellRangeAddress( OdfCellRangeAddress labelCellRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "label-cell-range-address" ), labelCellRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:data-cell-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getDataCellRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-cell-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:data-cell-range-address}.
     *
     *@param  dataCellRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setDataCellRangeAddress( OdfCellRangeAddress dataCellRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-cell-range-address" ), dataCellRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:orientation}.
     *
     *@return return the attribute which type is OdfLabelOrientationType
     */
    public OdfLabelOrientationType getOrientation()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "orientation" ) );
        return OdfLabelOrientationType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:orientation}.
     *
     *@param  orientation    the attribute's type is OdfLabelOrientationType
     */ 
     public void setOrientation( OdfLabelOrientationType orientation )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "orientation" ), orientation.toString() );
    }

}
