/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfStatusType;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:iteration}.
 *
 */
public abstract class OdfIterationElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "iteration" );

    /**
     * Create the instance of OdfIterationElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfIterationElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:iteration}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:status}.
     *
     *@return return the attribute which type is OdfStatusType
     */
    public OdfStatusType getStatus()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "status" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "disable";
        }

        return OdfStatusType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:status}.
     *
     *@param  status    the attribute's type is OdfStatusType
     */ 
     public void setStatus( OdfStatusType status )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "status" ), status.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:steps}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getSteps()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "steps" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "100";
        }

        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:steps}.
     *
     *@param  steps    the attribute's type is OdfPositiveInteger
     */ 
     public void setSteps( OdfPositiveInteger steps )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "steps" ), steps.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:maximum-difference}.
     *
     *@return return the attribute which type is Double
     */
    public Double getMaximumDifference()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "maximum-difference" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0.001";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:maximum-difference}.
     *
     *@param  maximumDifference    the attribute's type is Double
     */ 
     public void setMaximumDifference( Double maximumDifference )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "maximum-difference" ), maximumDifference.toString() );
    }

}
