/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;
import org.odftoolkit.odfdom.dom.type.table.OdfDirectionType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:highlighted-range}.
 *
 */
public abstract class OdfHighlightedRangeElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "highlighted-range" );

    /**
     * Create the instance of OdfHighlightedRangeElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfHighlightedRangeElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:highlighted-range}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfHighlightedRangeElement}
     *
     *@param direction  The mandatory attribute {@attributeName  table:direction}" 
     *@param markedInvalid  The mandatory attribute {@attributeName  table:marked-invalid}" 
     *
     */
    public void init(OdfDirectionType direction, OdfBoolean markedInvalid)
    {
        setDirection( direction );
        setMarkedInvalid( markedInvalid );
    }

    /**
     * Get value of attribute {@attributeName table:cell-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getCellRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:cell-range-address}.
     *
     *@param  cellRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setCellRangeAddress( OdfCellRangeAddress cellRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-range-address" ), cellRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:direction}.
     *
     *@return return the attribute which type is OdfDirectionType
     */
    public OdfDirectionType getDirection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "direction" ) );
        return OdfDirectionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:direction}.
     *
     *@param  direction    the attribute's type is OdfDirectionType
     */ 
     public void setDirection( OdfDirectionType direction )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "direction" ), direction.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:contains-error}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getContainsError()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "contains-error" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:contains-error}.
     *
     *@param  isContainsError    the attribute's type is OdfBoolean
     */ 
     public void setContainsError( OdfBoolean isContainsError )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "contains-error" ), isContainsError.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:marked-invalid}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getMarkedInvalid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "marked-invalid" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:marked-invalid}.
     *
     *@param  isMarkedInvalid    the attribute's type is OdfBoolean
     */ 
     public void setMarkedInvalid( OdfBoolean isMarkedInvalid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "marked-invalid" ), isMarkedInvalid.toString() );
    }

}
