/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:filter-or}.
 *
 */
public abstract class OdfFilterOrElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "filter-or" );

    /**
     * Create the instance of OdfFilterOrElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFilterOrElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:filter-or}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink table:filter-and}.
    *
    *@return   return  the element {@odfLink table:filter-and}
    */
    public OdfFilterAndElement createFilterAndElement()
    {
        OdfFilterAndElement  nFilterAnd = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterAndElement.class);
        this.appendChild( nFilterAnd);
        return  nFilterAnd;
    }                   
               
    /**
    * Create child element {@odfLink table:filter-condition}.
    *
    *@param fieldNumber  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@param value String   
    *@param operator String   
    *@return   return  the element {@odfLink table:filter-condition}
    */
    public OdfFilterConditionElement createFilterConditionElement(org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   fieldNumber, String   value, String   operator)
    {
        OdfFilterConditionElement  nFilterCondition = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterConditionElement.class);
        nFilterCondition.setFieldNumber( fieldNumber);
        nFilterCondition.setValue( value);
        nFilterCondition.setOperator( operator);
        this.appendChild( nFilterCondition);
        return  nFilterCondition;      
    }
    
}
