/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;
import org.odftoolkit.odfdom.dom.type.table.OdfConditionSourceType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:filter}.
 *
 */
public abstract class OdfFilterElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "filter" );

    /**
     * Create the instance of OdfFilterElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFilterElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:filter}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:target-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getTargetRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:target-range-address}.
     *
     *@param  targetRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setTargetRangeAddress( OdfCellRangeAddress targetRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-range-address" ), targetRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:condition-source}.
     *
     *@return return the attribute which type is OdfConditionSourceType
     */
    public OdfConditionSourceType getConditionSource()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "condition-source" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "self";
        }

        return OdfConditionSourceType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:condition-source}.
     *
     *@param  conditionSource    the attribute's type is OdfConditionSourceType
     */ 
     public void setConditionSource( OdfConditionSourceType conditionSource )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "condition-source" ), conditionSource.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:condition-source-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getConditionSourceRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "condition-source-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:condition-source-range-address}.
     *
     *@param  conditionSourceRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setConditionSourceRangeAddress( OdfCellRangeAddress conditionSourceRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "condition-source-range-address" ), conditionSourceRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:display-duplicates}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDisplayDuplicates()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-duplicates" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:display-duplicates}.
     *
     *@param  isDisplayDuplicates    the attribute's type is OdfBoolean
     */ 
     public void setDisplayDuplicates( OdfBoolean isDisplayDuplicates )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-duplicates" ), isDisplayDuplicates.toString() );
    }

    /**
    * Create child element {@odfLink table:filter-condition}.
    *
    *@param fieldNumber  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@param value String   
    *@param operator String   
    *@return   return  the element {@odfLink table:filter-condition}
    */
    public OdfFilterConditionElement createFilterConditionElement(org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   fieldNumber, String   value, String   operator)
    {
        OdfFilterConditionElement  nFilterCondition = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterConditionElement.class);
        nFilterCondition.setFieldNumber( fieldNumber);
        nFilterCondition.setValue( value);
        nFilterCondition.setOperator( operator);
        this.appendChild( nFilterCondition);
        return  nFilterCondition;      
    }
    
    /**
    * Create child element {@odfLink table:filter-and}.
    *
    *@return   return  the element {@odfLink table:filter-and}
    */
    public OdfFilterAndElement createFilterAndElement()
    {
        OdfFilterAndElement  nFilterAnd = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterAndElement.class);
        this.appendChild( nFilterAnd);
        return  nFilterAnd;
    }                   
               
    /**
    * Create child element {@odfLink table:filter-or}.
    *
    *@return   return  the element {@odfLink table:filter-or}
    */
    public OdfFilterOrElement createFilterOrElement()
    {
        OdfFilterOrElement  nFilterOr = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterOrElement.class);
        this.appendChild( nFilterOr);
        return  nFilterOr;
    }                   
               
}
