/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.table.OdfDataType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:filter-condition}.
 *
 */
public abstract class OdfFilterConditionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "filter-condition" );

    /**
     * Create the instance of OdfFilterConditionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFilterConditionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:filter-condition}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfFilterConditionElement}
     *
     *@param fieldNumber  The mandatory attribute {@attributeName  table:field-number}" 
     *@param value  The mandatory attribute {@attributeName  table:value}" 
     *@param operator  The mandatory attribute {@attributeName  table:operator}" 
     *
     */
    public void init(OdfNonNegativeInteger fieldNumber, String value, String operator)
    {
        setFieldNumber( fieldNumber );
        setValue( value );
        setOperator( operator );
    }

    /**
     * Get value of attribute {@attributeName table:field-number}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getFieldNumber()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "field-number" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:field-number}.
     *
     *@param  fieldNumber    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setFieldNumber( OdfNonNegativeInteger fieldNumber )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "field-number" ), fieldNumber.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:value}.
     *
     *@return return the attribute which type is String
     */
    public String getValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "value" ) );
    }

    /**
     * Set value of attribute {@attributeName table:value}.
     *
     *@param  value    the attribute's type is String
     */ 
     public void setValue( String value )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "value" ), value );
    }

    /**
     * Get value of attribute {@attributeName table:operator}.
     *
     *@return return the attribute which type is String
     */
    public String getOperator()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "operator" ) );
    }

    /**
     * Set value of attribute {@attributeName table:operator}.
     *
     *@param  operator    the attribute's type is String
     */ 
     public void setOperator( String operator )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "operator" ), operator );
    }

    /**
     * Get value of attribute {@attributeName table:case-sensitive}.
     *
     *@return return the attribute which type is String
     */
    public String getCaseSensitive()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "case-sensitive" ) );
    }

    /**
     * Set value of attribute {@attributeName table:case-sensitive}.
     *
     *@param  caseSensitive    the attribute's type is String
     */ 
     public void setCaseSensitive( String caseSensitive )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "case-sensitive" ), caseSensitive );
    }

    /**
     * Get value of attribute {@attributeName table:data-type}.
     *
     *@return return the attribute which type is OdfDataType
     */
    public OdfDataType getDataType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "text";
        }

        return OdfDataType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:data-type}.
     *
     *@param  dataType    the attribute's type is OdfDataType
     */ 
     public void setDataType( OdfDataType dataType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-type" ), dataType.toString() );
    }

    /**
    * Create child element {@odfLink table:filter-set-item}.
    *
    *@param value String   
    *@return   return  the element {@odfLink table:filter-set-item}
    */
    public OdfFilterSetItemElement createFilterSetItemElement(String   value)
    {
        OdfFilterSetItemElement  nFilterSetItem = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterSetItemElement.class);
        nFilterSetItem.setValue( value);
        this.appendChild( nFilterSetItem);
        return  nFilterSetItem;      
    }
    
}
