/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.table.OdfMessageType;

import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:error-message}.
 *
 */
public abstract class OdfErrorMessageElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "error-message" );

    /**
     * Create the instance of OdfErrorMessageElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfErrorMessageElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:error-message}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName table:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName table:display}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDisplay()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:display}.
     *
     *@param  isDisplay    the attribute's type is OdfBoolean
     */ 
     public void setDisplay( OdfBoolean isDisplay )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display" ), isDisplay.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:message-type}.
     *
     *@return return the attribute which type is OdfMessageType
     */
    public OdfMessageType getMessageType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "message-type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "stop";
        }

        return OdfMessageType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:message-type}.
     *
     *@param  messageType    the attribute's type is OdfMessageType
     */ 
     public void setMessageType( OdfMessageType messageType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "message-type" ), messageType.toString() );
    }

    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
}
